package org.gcube.portlets.admin.software_upload_wizard.server.importmanagers;


import org.gcube.portlets.admin.software_upload_wizard.server.aslmanagers.ASLSessionManager;
import org.gcube.portlets.admin.software_upload_wizard.server.data.ImportSession;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.slf4j.Logger;

import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class ASLImportSessionManager implements ImportSessionManager {
	
	private static final String IMPORT_SESSION_CODE = "ImportSession";
	
	@InjectLogger
	Logger logger;
	
	private ASLSessionManager manager;
	
	@Inject
	public ASLImportSessionManager(ASLSessionManager manager) {
		this.manager=manager;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.softwaremanagementwidget.server.managers.ImportSessionManager#getImportSession()
	 */
	@Override
	public ImportSession getImportSession(){
		ImportSession importSession = (ImportSession) manager.getASLSession().getAttribute(IMPORT_SESSION_CODE);
		logger.trace("Retrieved import session with id: " + importSession.getSessionId().getId());
		return importSession;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.softwaremanagementwidget.server.managers.ImportSessionManager#setImportSession(org.gcube.portlets.user.softwaremanagementwidget.server.data.ImportSession)
	 */
	@Override
	public void setImportSession(ImportSession importSession){
		manager.getASLSession().setAttribute(IMPORT_SESSION_CODE, importSession);
		logger.debug("Saved import session with id: " + importSession.getSessionId().getId());
	}
}