/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredefinition.client.presenter;

import com.extjs.gxt.ui.client.data.BaseModel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.gcube.portlets.admin.vredefinition.client.VREDefinitionServiceAsync;
import org.gcube.portlets.admin.vredefinition.client.model.VREDefinitionModel;
import org.gcube.portlets.admin.vredefinition.client.presenter.Presenter;
import org.gcube.portlets.admin.vredefinition.client.presenter.VREDescriptionPresenter;
import org.gcube.portlets.admin.vredefinition.shared.VREDescriptionBean;

public class VREDescriptionPresenter
implements Presenter {
    private final VREDefinitionModel vreModel;
    private final Display display;
    private final VREDefinitionServiceAsync rpcService;
    private LayoutContainer container;

    public VREDescriptionPresenter(VREDefinitionServiceAsync rpcService, VREDefinitionModel model, Display display) {
        this.vreModel = model;
        this.rpcService = rpcService;
        this.display = display;
    }

    public boolean doSave() {
        String description = (String)this.display.getVREDescription().getValue();
        String designer = (String)this.display.getVREDesigner().getValue();
        String name = (String)this.display.getVREName().getValue();
        String manager = null;
        if (this.display.getVREManager().getValue() != null) {
            manager = (String)((BaseModel)this.display.getVREManager().getValue()).get("name");
        }
        Date fromDate = (Date)this.display.getFromDate().getValue();
        Date toDate = (Date)this.display.getToDate().getValue();
        VREDescriptionBean bean = new VREDescriptionBean(name, description, designer, manager, fromDate, toDate);
        this.vreModel.setVREDescription(bean);
        return this.validateForm();
    }

    public void go(LayoutContainer container) {
        this.container = container;
        container.removeAll();
        this.getVREInfo();
        container.add(this.display.asWidget());
        container.mask("Loading data...", "loading-indicator");
        container.layout();
    }

    private void getVREInfo() {
        this.rpcService.getVRE((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean validateForm() {
        VREDescriptionBean bean = this.vreModel.getVREDescriptionBean();
        boolean check = true;
        if (bean.getName() == null || bean.getName().trim().isEmpty() || bean.getName().contains(" ")) {
            check = false;
        }
        if (bean.getDescription() == null || bean.getDescription().trim().isEmpty()) {
            check = false;
        }
        if (bean.getDesigner() == null || bean.getDesigner().trim().isEmpty()) {
            check = false;
        }
        if (bean.getManager() == null || bean.getManager().trim().isEmpty()) {
            check = false;
        }
        if (bean.getStartTime() == null) {
            check = false;
        }
        if (bean.getEndTime() == null) {
            check = false;
        }
        return check;
    }

    public Widget display() {
        return this.display.asWidget();
    }

    static /* synthetic */ VREDefinitionModel access$000(VREDescriptionPresenter x0) {
        return x0.vreModel;
    }

    static /* synthetic */ Display access$100(VREDescriptionPresenter x0) {
        return x0.display;
    }

    static /* synthetic */ LayoutContainer access$200(VREDescriptionPresenter x0) {
        return x0.container;
    }
}

