/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredeployment.client.view;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.fx.FxConfig;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.admin.vredeployment.client.view.Display;
import org.gcube.portlets.admin.vredeployment.shared.VREDefinitionBean;
import org.gcube.portlets.user.gcubewidgets.client.GCubePanel;

public class VREDeploymentView
extends Composite
implements Display {
    private GCubePanel mainPanel = new GCubePanel("VRE Manager", "https://gcube.wiki.gcube-system.org/gcube/index.php/VRE_Administration#VRE_Approval");
    private final ContentPanel tablePanel = new ContentPanel((Layout)new FitLayout());
    private GroupingStore<VREDefinitionBean> store;
    private Grid<VREDefinitionBean> grid;
    private Button viewButton;
    private Button editButton;
    private Button removeButton;
    private Button approveButton;
    private Button viewReportButton;
    private Button refreshButton;
    private Button viewTextualReportButton;
    private MenuItem viewMenu;
    private MenuItem editMenu;
    private MenuItem removeMenu;
    private MenuItem approveMenu;
    private MenuItem viewReportMenu;
    private Menu gridMenu;

    public VREDeploymentView() {
        this.tablePanel.setHeaderVisible(false);
        this.tablePanel.setFrame(false);
        this.tablePanel.setStyleAttribute("Margin", "5px");
        this.mainPanel.add((Widget)this.tablePanel);
        this.store = new GroupingStore();
        GroupingView view = new GroupingView();
        view.setShowGroupedColumn(false);
        view.setForceFit(true);
        ColumnModel cm = this.getVREListColumnModel();
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.grid = new Grid((ListStore)this.store, cm);
        this.grid.setView((GridView)view);
        this.viewMenu = new MenuItem("View details");
        this.viewMenu.setIconStyle("view-icon");
        this.editMenu = new MenuItem("Edit");
        this.editMenu.setIconStyle("edit-icon");
        this.approveMenu = new MenuItem("Approve");
        this.approveMenu.setIconStyle("approve-icon");
        this.viewReportMenu = new MenuItem("View Report");
        this.viewReportMenu.setIconStyle("viewreport-icon");
        this.removeMenu = new MenuItem("Remove from infrastructure");
        this.removeMenu.setIconStyle("remove-icon");
        this.gridMenu = new Menu();
        this.grid.setContextMenu(this.gridMenu);
        this.viewButton = new Button("View details");
        this.editButton = new Button("Edit");
        this.approveButton = new Button("Approve");
        this.viewReportButton = new Button("View Report");
        this.removeButton = new Button("Remove from infrastructure");
        this.refreshButton = new Button("Refresh");
        this.viewTextualReportButton = new Button("View Text-Only Report");
        this.viewButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.approveButton.setEnabled(false);
        this.viewReportButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.refreshButton.setEnabled(true);
        this.viewTextualReportButton.setEnabled(false);
        this.initWidget((Widget)this.mainPanel);
        this.updateSize();
    }

    private void displayDocuments() {
        this.tablePanel.removeAll();
        this.grid.setStyleAttribute("borderTop", "none");
        this.grid.setAutoExpandColumn("name");
        this.grid.setBorders(true);
        this.grid.setStripeRows(true);
        this.grid.getView().setForceFit(true);
        ContentPanel gridPanel = new ContentPanel((Layout)new FitLayout());
        gridPanel.setHeaderVisible(false);
        gridPanel.add((Widget)this.grid);
        gridPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        gridPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        gridPanel.addButton(this.viewButton);
        gridPanel.addButton(this.editButton);
        gridPanel.addButton(this.approveButton);
        gridPanel.addButton(this.viewReportButton);
        gridPanel.addButton(this.viewTextualReportButton);
        gridPanel.addButton(this.removeButton);
        gridPanel.addButton(this.refreshButton);
        gridPanel.setBorders(false);
        this.tablePanel.add((Widget)gridPanel);
        this.tablePanel.setLayout((Layout)new FitLayout());
        this.tablePanel.layout();
    }

    public void maskCenterPanel(String message, boolean mask) {
        if (mask) {
            this.tablePanel.mask(message, "loading-indicator");
        } else {
            this.tablePanel.unmask();
        }
    }

    public void setData(List<VREDefinitionBean> data) {
        this.store.removeAll();
        this.store.groupBy("status");
        this.store.add(data);
        this.displayDocuments();
    }

    public Widget asWidget() {
        return this;
    }

    public void updateSize() {
        RootPanel workspace = RootPanel.get((String)"DeploymentView");
        int topBorder = workspace.getAbsoluteTop();
        int leftBorder = workspace.getAbsoluteLeft();
        int rightScrollBar = 17;
        int rootHeight = Window.getClientHeight() - topBorder - 4;
        int rootWidth = Window.getClientWidth() - 2 * leftBorder - rightScrollBar;
        this.tablePanel.setPixelSize(rootWidth - 30, rootHeight - 30);
        this.mainPanel.setPixelSize(rootWidth - 30, rootHeight - 30);
    }

    private ColumnModel getVREListColumnModel() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig();
        column = new ColumnConfig();
        column.setId("name");
        column.setHeader("VRE name");
        column.setWidth(100);
        configs.add(column);
        column = new ColumnConfig();
        column.setId("status");
        column.setHeader("Status");
        column.setHidden(false);
        column.setWidth(75);
        column.setRowHeader(true);
        configs.add(column);
        column = new ColumnConfig("description", "Description", 300);
        column.setHidden(false);
        column.setRowHeader(true);
        configs.add(column);
        return new ColumnModel(configs);
    }

    public void enableActionButtons(VREDefinitionBean selectedItem) {
        if (selectedItem != null) {
            if (selectedItem.getStatus().compareTo("Failed") == 0 || selectedItem.getStatus().compareTo("Finished") == 0 || selectedItem.getStatus().compareTo("Deployed") == 0) {
                this.getViewButton().setEnabled(true);
                this.getEditButton().setEnabled(false);
                this.getApproveButton().setEnabled(false);
                this.getRemoveButton().setEnabled(true);
                this.getViewReportButton().setEnabled(true);
                this.getViewTextualReportButton().setEnabled(true);
            } else if (selectedItem.getStatus().compareTo("Running") == 0 || selectedItem.getStatus().compareTo("Deploying") == 0) {
                this.getViewButton().setEnabled(true);
                this.getEditButton().setEnabled(false);
                this.getApproveButton().setEnabled(false);
                this.getRemoveButton().setEnabled(false);
                this.getViewReportButton().setEnabled(true);
                this.getViewTextualReportButton().setEnabled(true);
            } else if (selectedItem.getStatus().compareTo("Pending") == 0 || selectedItem.getStatus().compareTo("Incomplete") == 0 || selectedItem.getStatus().compareTo("Disposed") == 0) {
                this.getViewButton().setEnabled(true);
                this.getEditButton().setEnabled(true);
                this.getApproveButton().setEnabled(true);
                this.getRemoveButton().setEnabled(true);
                this.getViewReportButton().setEnabled(false);
            }
        } else {
            this.getViewButton().setEnabled(false);
            this.getEditButton().setEnabled(false);
            this.getApproveButton().setEnabled(false);
            this.getRemoveButton().setEnabled(false);
            this.getViewReportButton().setEnabled(false);
            this.getViewTextualReportButton().setEnabled(false);
        }
    }

    public void showDetailsDialog(String html2Show) {
        Dialog simple = new Dialog();
        simple.setHeading("VRE Details");
        simple.setButtons("close");
        simple.setBodyStyleName("pad-text");
        Html toDisplay = new Html(html2Show);
        simple.add((Widget)toDisplay);
        simple.getItem(0).getFocusSupport().setIgnore(true);
        simple.setScrollMode(Style.Scroll.AUTO);
        simple.setHideOnButtonClick(true);
        simple.setModal(true);
        simple.setSize(600, 450);
        simple.setMaximizable(true);
        simple.show();
        simple.el().fadeIn(FxConfig.NONE);
    }

    public void setGridContextMenu(String vreStatus) {
        this.gridMenu.removeAll();
        if (vreStatus.compareTo("Failed") == 0 || vreStatus.compareTo("Finished") == 0 || vreStatus.compareTo("Deployed") == 0) {
            this.gridMenu.add((Component)this.viewMenu);
            this.gridMenu.add((Component)this.removeMenu);
            this.gridMenu.add((Component)this.viewReportMenu);
        } else if (vreStatus.compareTo("Running") == 0 || vreStatus.compareTo("Deploying") == 0) {
            this.gridMenu.add((Component)this.viewReportMenu);
            this.gridMenu.add((Component)this.viewMenu);
        } else if (vreStatus.compareTo("Pending") == 0) {
            this.gridMenu.add((Component)this.approveMenu);
            this.gridMenu.add((Component)this.viewMenu);
            this.gridMenu.add((Component)this.editMenu);
            this.gridMenu.add((Component)this.removeMenu);
        } else if (vreStatus.compareTo("Incomplete") == 0 || vreStatus.compareTo("Disposed") == 0) {
            this.gridMenu.add((Component)this.approveMenu);
            this.gridMenu.add((Component)this.viewMenu);
            this.gridMenu.add((Component)this.editMenu);
            this.gridMenu.add((Component)this.removeMenu);
        }
    }

    public Button getApproveButton() {
        return this.approveButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public GridSelectionModel<VREDefinitionBean> getGridSelectionModel() {
        return this.grid.getSelectionModel();
    }

    public Button getRefreshButton() {
        return this.refreshButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Button getViewButton() {
        return this.viewButton;
    }

    public Button getViewReportButton() {
        return this.viewReportButton;
    }

    public Button getViewTextualReportButton() {
        return this.viewTextualReportButton;
    }

    public MenuItem getApproveMenu() {
        return this.approveMenu;
    }

    public MenuItem getEditMenu() {
        return this.editMenu;
    }

    public MenuItem getRemoveMenu() {
        return this.removeMenu;
    }

    public MenuItem getViewMenu() {
        return this.viewMenu;
    }

    public MenuItem getViewReportMenu() {
        return this.viewReportMenu;
    }
}

