/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredeployment.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.vremanagement.vremanagement.impl.VREGeneratorEvo;
import org.gcube.portlets.admin.vredeployment.client.VREDeploymentService;
import org.gcube.portlets.admin.vredeployment.shared.VREDefinitionBean;
import org.gcube.vremanagement.vremodel.cl.stubs.types.FunctionalityItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.Report;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceDescriptionItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.VREDescription;
import org.gcube.vremanagement.vremodeler.utils.Utils;
import org.gcube.vremanagement.vremodeler.utils.reports.DeployReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VREDeploymentServiceImpl
extends RemoteServiceServlet
implements VREDeploymentService {
    private static final Logger _log = LoggerFactory.getLogger(VREDeploymentServiceImpl.class);
    private static final String APPROVE_MODE = "approve";
    private static final String EDIT_MODE = "edit";
    private static final String REEDIT_TYPE_ATTRIBUTE = "reeditType";
    private static final String VRE_GENERATOR_ATTRIBUTE = "VREGenerator";
    private static final String VIEW_MODE_ATTRIBUTE = "viewMode";
    private static final String HARD_CODED_VO_NAME = "/gcube/devsec";
    private static final String DEPLOYING = "DEPLOYING";

    public ArrayList<VREDefinitionBean> getVREDefinitions() {
        ASLSession aslSession = this.getASLSession();
        ArrayList<VREDefinitionBean> toReturn = new ArrayList<VREDefinitionBean>();
        System.out.println("getAllVREs");
        VREGeneratorEvo evo = new VREGeneratorEvo(aslSession);
        List vres = evo.getAllVREs(aslSession);
        if (vres == null || vres.isEmpty()) {
            return toReturn;
        }
        for (Report vre : vres) {
            if (vre.name().equals("notCompletedVirtualResearchEnv.")) {
                _log.debug("removing fake vre" + vre.name());
                this.doRemove(vre.id());
                continue;
            }
            toReturn.add(new VREDefinitionBean(vre.id(), vre.name(), vre.description(), "", "", new Date(), new Date(), vre.state(), ""));
            _log.debug(vre.name() + " id=" + vre.id());
        }
        return toReturn;
    }

    private ASLSession getASLSession() {
        HttpSession session = this.getThreadLocalRequest().getSession();
        String username = (String)session.getAttribute("username");
        if (username == null) {
            username = "massimiliano.assante";
            SessionManager.getInstance().getASLSession(session.getId(), username).setScope(HARD_CODED_VO_NAME);
        }
        return SessionManager.getInstance().getASLSession(session.getId(), username);
    }

    public boolean doApprove(String epr) {
        System.out.println("---   approve    ---");
        epr = this.unCodeERP(epr);
        _log.debug("VRE Instance to approve at epr: " + epr);
        ASLSession d4ScienceSession = this.getASLSession();
        _log.debug("doApprove id: " + epr + " Scope: " + d4ScienceSession.getScopeName());
        d4ScienceSession.setAttribute(VRE_GENERATOR_ATTRIBUTE, (Object)epr);
        d4ScienceSession.setAttribute(REEDIT_TYPE_ATTRIBUTE, (Object)APPROVE_MODE);
        _log.debug("REEDIT_TYPE_ATTRIBUTE SET: approve");
        this.setDeployingStatusOff();
        d4ScienceSession.setAttribute(VIEW_MODE_ATTRIBUTE, (Object)new Boolean(false));
        return true;
    }

    private void setDeployingStatusOff() {
        _log.debug("---  setDeployingStatusOff   ---");
        this.getASLSession().setAttribute(DEPLOYING, null);
    }

    private String unCodeERP(String epr) {
        epr = epr.replace("&gt;", ">");
        epr = epr.replace("&lt;", "<");
        epr = epr.replace("&quot;", "\"");
        return epr;
    }

    public boolean doRemove(String epr) {
        ASLSession aslSession = this.getASLSession();
        VREGeneratorEvo evo = new VREGeneratorEvo(aslSession);
        evo.removeVRE(aslSession, epr);
        return true;
    }

    public boolean doEdit(String epr) {
        epr = this.unCodeERP(epr);
        _log.debug("VRE Instance to edit at epr: " + epr);
        ASLSession session = this.getASLSession();
        session.setAttribute(VRE_GENERATOR_ATTRIBUTE, (Object)epr);
        session.setAttribute(REEDIT_TYPE_ATTRIBUTE, (Object)EDIT_MODE);
        session.setAttribute(VIEW_MODE_ATTRIBUTE, (Object)new Boolean(false));
        return true;
    }

    public String doViewDetails(String epr) {
        String toReturn = "";
        epr = this.unCodeERP(epr);
        _log.debug("VRE Instance to edit at epr: " + epr);
        try {
            ASLSession session = this.getASLSession();
            VREGeneratorEvo vreGenerator = new VREGeneratorEvo(session, epr);
            toReturn = this.getHTMLDescription(vreGenerator);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "Could not retrieve VRE info, cause: " + e.getMessage();
        }
        return toReturn;
    }

    public boolean doViewReport(String epr) {
        _log.debug("---   view REPORT    ---");
        _log.debug("VRE Instance to view at encoded epr: " + epr);
        ASLSession session = this.getASLSession();
        session.setAttribute(VRE_GENERATOR_ATTRIBUTE, (Object)epr);
        this.getASLSession().setAttribute(DEPLOYING, (Object)"ON");
        return true;
    }

    private String getHTMLDescription(VREGeneratorEvo evo) throws RemoteException {
        String toReturn = "";
        VREDescription vre = evo.getVREModel();
        String vreDescription = "<div STYLE=\"font-size:18px;\" align=\"center\" ><h1> Summary </h1></div>";
        vreDescription = vreDescription + "<div><b>Name: </b>" + vre.name() + "</div>";
        vreDescription = vreDescription + "<div><b>VRE Designer: </b>" + vre.designer() + "</div>";
        vreDescription = vreDescription + "<div><b>VRE Manager: </b>" + vre.manager() + "</div>";
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, MMM d, ''yy");
        vreDescription = vreDescription + "<div ><b>From: </b>" + fmt.format(vre.startTime().getTime()) + " <b> To: </b>" + fmt.format(vre.endTime().getTime()) + "</div>";
        vreDescription = vreDescription + "<br />";
        vreDescription = vreDescription + "<div><b>Description: </b>" + vre.description() + "</div>";
        vreDescription = vreDescription + "<br />";
        vreDescription = vreDescription + "<div style=\"font-size:14px;\" align=\"center\" >Functionalities</div>";
        vreDescription = vreDescription + "<table>";
        try {
            List list = evo.getFunctionality();
            if (list == null) {
                _log.warn("FunctionalityList NULL");
            } else {
                for (FunctionalityItem fi : list) {
                    vreDescription = vreDescription + "<tr><td><span style=\"font-weight: bold; color: #333; font-size: 12px;\">" + fi.name() + "</span></td></tr>";
                    if (fi.children() == null || fi.children().isEmpty()) continue;
                    List children = fi.children();
                    for (int i = 0; i < children.size(); ++i) {
                        if (!((FunctionalityItem)children.get(i)).selected()) continue;
                        vreDescription = vreDescription + "<tr><td><span class=\"funcadd\">" + ((FunctionalityItem)children.get(i)).name() + "</span></td></tr>";
                        if (((FunctionalityItem)children.get(i)).selectableResourcesDescription() == null) continue;
                        for (ResourceDescriptionItem category : ((FunctionalityItem)children.get(i)).selectableResourcesDescription()) {
                            if (category.resources() == null) continue;
                            for (ResourceItem resource : category.resources()) {
                                if (!resource.selected()) continue;
                                vreDescription = vreDescription + "<tr><td><span class=\"extres\" >" + resource.name() + "</span></td></tr>";
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vreDescription = vreDescription + "</table>";
        toReturn = toReturn + vreDescription;
        return toReturn;
    }

    public String getHTMLReport(String epr) {
        epr = this.unCodeERP(epr);
        _log.info("--- getHTMLReport VRE  ---");
        ASLSession session = this.getASLSession();
        VREGeneratorEvo vreGenerator = new VREGeneratorEvo(session, epr);
        String report = null;
        try {
            report = Utils.toXML((DeployReport)vreGenerator.checkVREStatus());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        String startDirectory = this.getServletContext().getRealPath("");
        String xslFileLocation = startDirectory + "/styles/report.xsl";
        String transformed = "";
        transformed = this.transformToHtml(report, xslFileLocation);
        return transformed;
    }

    private String transformToHtml(String profile, String xslFile) {
        File stylesheet = new File(xslFile);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(stylesheet);
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer(stylesource);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return "";
        }
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return "";
        }
        StringReader reader = new StringReader(profile);
        InputSource inputSource = new InputSource(reader);
        _log.debug("***** --- Reading **** ");
        try {
            document = builder.parse(inputSource);
        }
        catch (SAXException e) {
            _log.error("***** --- ERROR PARSING REPORT SAXException--- **** ");
            _log.error("CHECK THIS: \n" + profile);
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(resultStream);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return "";
        }
        return resultStream.toString();
    }
}

