/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.wftemplates.client.presenter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.orange.links.client.connection.Connection;
import com.orange.links.client.event.TieLinkHandler;
import com.orange.links.client.utils.Direction;
import com.orange.links.client.utils.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.admin.wfdocslibrary.shared.EdgeDirection;
import org.gcube.portlets.admin.wfdocslibrary.shared.EdgePoint;
import org.gcube.portlets.admin.wfdocslibrary.shared.ForwardAction;
import org.gcube.portlets.admin.wfdocslibrary.shared.Step;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfGraph;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRole;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRoleDetails;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfTemplate;
import org.gcube.portlets.admin.wftemplates.client.WfTemplatesServiceAsync;
import org.gcube.portlets.admin.wftemplates.client.presenter.MyDiagramController;
import org.gcube.portlets.admin.wftemplates.client.presenter.Presenter;
import org.gcube.portlets.admin.wftemplates.client.presenter.WfTemplatesPresenter;
import org.gcube.portlets.admin.wftemplates.client.view.WfStep;
import org.gcube.portlets.admin.wftemplates.client.view.dialog.AddRolesDialog;

public class WfTemplatesPresenter
implements Presenter {
    private final WfTemplatesServiceAsync rpcService;
    private final HandlerManager eventBus;
    private final Display display;
    private final TieLinkHandler linkHandler;
    private ArrayList<WfRoleDetails> rolesCache = null;
    private HashMap<Connection, ArrayList<WfRoleDetails>> edgesMap;

    public WfTemplatesPresenter(WfTemplatesServiceAsync rpcService, HandlerManager eventBus, Display display) {
        this.rpcService = rpcService;
        this.eventBus = eventBus;
        this.display = display;
        this.linkHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.edgesMap = new HashMap();
        display.enableDeleteButton(false);
    }

    public void bind() {
        this.display.getSaveButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getCreateNewButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getDeleteButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getResetButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getAddNewStepButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.display.getTableSelectionModel().addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void go(HasWidgets container) {
        this.bind();
        container.clear();
        container.add(this.display.asWidget());
        this.fetchTemplatesList();
    }

    public void addRolesOnConnection(Connection selectedEdge, ArrayList<WfRoleDetails> roles) {
        this.edgesMap.put(selectedEdge, roles);
        String toDisplay = "";
        for (int i = 0; i < roles.size(); ++i) {
            toDisplay = toDisplay + roles.get(i).getDisplayName() + " ";
        }
        this.display.addNewRoles(selectedEdge, toDisplay);
    }

    private void showAddRoleDialog(Connection selectedEdge) {
        if (this.rolesCache == null) {
            this.rpcService.getRoleDetails((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            AddRolesDialog dlg = new AddRolesDialog(this.eventBus, selectedEdge, this.rolesCache);
            dlg.show();
        }
    }

    private void fetchTemplatesList() {
        this.display.showLoading(true);
        this.rpcService.getTemplates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addNewStep(String label, String description) {
        this.display.addNewStep(label, description, new int[0]);
    }

    public void doSaveTemplate(String templateName) {
        WfGraph toSave = this.getWorkflowFromView();
        GWT.log((String)"Calling SaveTemplate()");
        this.rpcService.saveTemplate(templateName, toSave, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private WfGraph getWorkflowFromView() {
        WfGraph wf = null;
        Step[] steps = this.getSteps().toArray(new Step[0]);
        for (int i = 0; i < steps.length; ++i) {
            GWT.log((String)("Step " + steps[i].getLabel()));
        }
        GWT.log((String)"Instanzio WfGraph(steps)");
        wf = new WfGraph(steps);
        for (Map.Entry elem : this.edgesMap.entrySet()) {
            Connection c = (Connection)elem.getKey();
            Step start = this.getStepByCoordinates(c.getStartShape().getLeft(), c.getStartShape().getTop());
            Step end = this.getStepByCoordinates(c.getEndShape().getLeft(), c.getEndShape().getTop());
            GWT.log((String)"Before getEdgePointsFromConnection ");
            ArrayList points = this.getEdgePointsFromConnection(c);
            GWT.log((String)"After getEdgePointsFromConnection ");
            WfRole[] roles = new WfRole[]{};
            if (elem.getValue() != null) {
                roles = new WfRole[((ArrayList)elem.getValue()).size()];
                for (int i = 0; i < roles.length; ++i) {
                    roles[i] = new WfRole(((WfRoleDetails)((ArrayList)elem.getValue()).get(i)).getId(), ((WfRoleDetails)((ArrayList)elem.getValue()).get(i)).getDisplayName(), "");
                }
            }
            GWT.log((String)"Before addEdge");
            wf.addEdge(start, end, new ForwardAction((List)points, roles));
            GWT.log((String)"Edge added");
        }
        return wf;
    }

    private ArrayList<EdgePoint> getEdgePointsFromConnection(Connection c) {
        ArrayList<EdgePoint> toReturn = new ArrayList<EdgePoint>();
        for (Point p : c.getMovablePoints()) {
            EdgePoint ep = new EdgePoint(p.getLeft(), p.getTop());
            if (p.getDirection() != null) {
                ep.setEdgeDirection(this.getEdgeDirection(p.getDirection()));
            }
            toReturn.add(ep);
        }
        return toReturn;
    }

    private EdgeDirection getEdgeDirection(Direction d) {
        return new EdgeDirection(d.toString(), d.getAngle());
    }

    private Step getStepByCoordinates(int left, int top) {
        for (Step s : this.getSteps()) {
            if (s.getLeft() != left || s.getTop() != top) continue;
            return s;
        }
        return null;
    }

    private ArrayList<Step> getSteps() {
        ArrayList<Step> toReturn = new ArrayList<Step>();
        AbsolutePanel container = this.display.getDiagramController().getView();
        int containerLeft = container.getAbsoluteLeft();
        int containerTop = container.getAbsoluteTop();
        int wtsNO = container.getWidgetCount();
        for (int i = 0; i < wtsNO; ++i) {
            Widget w = container.getWidget(i);
            int left = w.getAbsoluteLeft() - containerLeft;
            int top = w.getAbsoluteTop() - containerTop;
            if (!(w instanceof WfStep)) continue;
            WfStep toAdd = (WfStep)w;
            if (toAdd.getText().equalsIgnoreCase("Start")) {
                toReturn.add(0, new Step(left, top, toAdd.getText(), toAdd.getDescription()));
                continue;
            }
            toReturn.add(new Step(left, top, toAdd.getText(), toAdd.getDescription()));
        }
        return toReturn;
    }

    public void doRemoveConnectionFromModel(Connection selected) {
        this.edgesMap.remove(selected);
    }

    public void doRemoveStep(WfStep step) {
        AbsolutePanel container = this.display.getDiagramController().getView();
        int containerLeft = container.getAbsoluteLeft();
        int containerTop = container.getAbsoluteTop();
        int left = step.getAbsoluteLeft() - containerLeft;
        int top = step.getAbsoluteTop() - containerTop;
        ArrayList<Connection> toRemove = new ArrayList<Connection>();
        GWT.log((String)("doRemoveStep() Step: " + left + " - " + top));
        for (Map.Entry elem : this.edgesMap.entrySet()) {
            Connection c = (Connection)elem.getKey();
            if (c.getStartShape().getLeft() == left && c.getStartShape().getTop() == top) {
                toRemove.add(c);
                continue;
            }
            if (c.getEndShape().getLeft() != left || c.getEndShape().getTop() != top) continue;
            toRemove.add(c);
        }
        for (Connection connection : toRemove) {
            this.display.getDiagramController().deleteConnection(connection);
        }
    }

    public void doRemoveConnectionFromView(Connection selected) {
        MyDiagramController myDC = this.display.getDiagramController();
        myDC.deleteConnection(selected);
    }

    public void doDeleteTemplate(WfTemplate toDelete) {
        this.rpcService.deleteTemplate(toDelete, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(WfTemplatesPresenter x0, Connection x1) {
        x0.showAddRoleDialog(x1);
    }

    static /* synthetic */ HandlerManager access$100(WfTemplatesPresenter x0) {
        return x0.eventBus;
    }

    static /* synthetic */ HashMap access$202(WfTemplatesPresenter x0, HashMap x1) {
        x0.edgesMap = x1;
        return x0.edgesMap;
    }

    static /* synthetic */ TieLinkHandler access$300(WfTemplatesPresenter x0) {
        return x0.linkHandler;
    }

    static /* synthetic */ Display access$400(WfTemplatesPresenter x0) {
        return x0.display;
    }

    static /* synthetic */ ArrayList access$502(WfTemplatesPresenter x0, ArrayList x1) {
        x0.rolesCache = x1;
        return x0.rolesCache;
    }

    static /* synthetic */ void access$600(WfTemplatesPresenter x0) {
        x0.fetchTemplatesList();
    }
}

