/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.accountingdashboard.server.is;

import java.util.ArrayList;
import org.gcube.portlets.user.accountingdashboard.server.is.AccountingDashboardConfigJAXB;
import org.gcube.portlets.user.accountingdashboard.server.is.InformationSystemUtils;
import org.gcube.portlets.user.accountingdashboard.server.is.InfraNodeJAXB;
import org.gcube.portlets.user.accountingdashboard.shared.exception.ServiceException;
import org.gcube.portlets.user.accountingdashboard.shared.is.InfraNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BuildInfraNode {
    private static Logger logger = LoggerFactory.getLogger(BuildInfraNode.class);

    public static InfraNode build(String scope) throws ServiceException {
        logger.info("Build Infra Nodes");
        InfraNode infraNode = null;
        AccountingDashboardConfigJAXB accountingDashboardConfigJAXB = null;
        try {
            accountingDashboardConfigJAXB = InformationSystemUtils.retrieveAccountingDashboardConfig((String)scope);
        }
        catch (ServiceException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
        if (accountingDashboardConfigJAXB != null) {
            logger.info("AccountingDashboard: use configuration in scope: " + scope);
            if (accountingDashboardConfigJAXB.isEnabledInfraNode()) {
                logger.info("AccountingDashboard: Infra Nodes configuration enabled in scope: " + scope);
                InfraNodeJAXB infraNodeJAXB = accountingDashboardConfigJAXB.getBaseInfraNode();
                logger.info("AccountingDashboard: Base Infra Nodes configuration: " + infraNodeJAXB);
                if (infraNodeJAXB != null) {
                    infraNode = new InfraNode(infraNodeJAXB.getScope(), infraNodeJAXB.getName(), infraNodeJAXB.getDescription());
                    if (infraNodeJAXB.getChildren() != null && !infraNodeJAXB.getChildren().isEmpty()) {
                        ArrayList children = BuildInfraNode.retrieveChildren((InfraNodeJAXB)infraNodeJAXB);
                        infraNode.setChildren(children);
                    }
                } else {
                    logger.info("AccountingDashboard: Base Infra Nodes is not present in configuration resource for scope: " + scope);
                }
            } else {
                logger.info("AccountingDashboard: Infra Nodes configuration disabled for scope: " + scope);
            }
        } else {
            logger.info("AccountingDashboard: configuration resource is not present in scope: " + scope);
        }
        logger.debug("AccountingDashboard: Infra Nodes configuration set: " + infraNode);
        return infraNode;
    }

    private static InfraNode useDefaultConfiguration() {
        InfraNode infraNodeCoreServices = new InfraNode("CoreServices", "Core Services");
        InfraNode infraNodeCatalogue = new InfraNode("Catalogue", "Catalogue");
        InfraNode infraNodeWorkspace = new InfraNode("Workspace", "Workspace");
        InfraNode infraNodeMessages = new InfraNode("Messages", "Messages");
        ArrayList<InfraNode> children = new ArrayList<InfraNode>();
        children.add(infraNodeCatalogue);
        children.add(infraNodeWorkspace);
        children.add(infraNodeMessages);
        infraNodeCoreServices.setChildren(children);
        return infraNodeCoreServices;
    }

    private static ArrayList<InfraNode> retrieveChildren(InfraNodeJAXB infraNodeJAXB) throws ServiceException {
        try {
            ArrayList<InfraNode> children = new ArrayList<InfraNode>();
            for (InfraNodeJAXB childJAXB : infraNodeJAXB.getChildren()) {
                InfraNode child = new InfraNode(childJAXB.getScope(), childJAXB.getName(), childJAXB.getDescription());
                if (childJAXB.getChildren() != null && !childJAXB.getChildren().isEmpty()) {
                    ArrayList childrenOfChild = BuildInfraNode.retrieveChildren((InfraNodeJAXB)childJAXB);
                    child.setChildren(childrenOfChild);
                }
                children.add(child);
            }
            return children;
        }
        catch (Throwable e) {
            logger.error("Ivalid infra nodes configuration. Error retrieving children for infra nodes: " + e.getLocalizedMessage(), e);
            throw new ServiceException("Ivalid infra nodes configuration. Error retrieving children for infra nodes: " + e.getLocalizedMessage(), e);
        }
    }
}

