/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.collectionsviewer.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.collectionsviewer.client.ViewerService;
import org.gcube.portlets.user.collectionsviewer.shared.CollectionBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ViewerServiceImpl
extends RemoteServiceServlet
implements ViewerService {
    private static final Logger log = LoggerFactory.getLogger(ViewerServiceImpl.class);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        System.out.println("getASLSession COLLECTIONS");
        if (user == null) {
            user = "massimiliano.assante";
            ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
            session.setScope("/gcube/devsec");
            return session;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public List<CollectionBean> getAvailableCollections() {
        ArrayList<CollectionBean> toReturn = new ArrayList<CollectionBean>();
        log.debug("GETTING AVAILABLE COLLECTIONS");
        try {
            QueryBox query = new QueryBox("for $resource in collection('/db/Properties')//Document where $resource//Document/Data/child::*[local-name()='ServiceClass']/text() eq 'DataAccess' and  $resource//Document/Data/child::*[local-name()='ServiceName']/text() eq 'tree-manager-service'  return $resource");
            String currScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(this.getASLSession().getScope());
            DiscoveryClient client = ICFactory.client();
            List results = client.submit((Query)query);
            ScopeProvider.instance.set(currScope);
            for (String result : results) {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(result))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                String name = !helper.evaluate("//*[local-name()='Name']/text()").isEmpty() ? (String)helper.evaluate("//*[local-name()='Name']/text()").get(0) : "no name";
                String id = !helper.evaluate("//*[local-name()='SourceId']/text()").isEmpty() ? (String)helper.evaluate("//*[local-name()='SourceId']/text()").get(0) : "no id";
                String totalItems = helper.evaluate("//*[local-name()='Cardinality']/text()").size() > 0 ? (String)helper.evaluate("//*[local-name()='Cardinality']/text()").get(0) : "0";
                toReturn.add(new CollectionBean(id, name, "No Description Available, total items: " + totalItems, new Date(), "Tree Manager"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("ERROR GETTING AVAILABLE COLLECTIONS");
            toReturn.add(new CollectionBean("0000", "NO COLLECTION", "", new Date(), "Content Manager"));
            return toReturn;
        }
        log.trace("Printing COLLECTIONS");
        for (CollectionBean collectionBean : toReturn) {
            log.trace("COLLECTION " + collectionBean.getName() + " FROM: " + collectionBean.getSource());
        }
        log.debug("GOT AVAILABLE COLLECTIONS");
        return toReturn;
    }
}

