package org.gcube.portlets.user.collectionsviewer.server;

import static org.gcube.resources.discovery.icclient.ICFactory.client;
import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.tml.Constants;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.collectionsviewer.client.ViewerService;
import org.gcube.portlets.user.collectionsviewer.shared.CollectionBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class ViewerServiceImpl extends RemoteServiceServlet implements ViewerService {

	private static final Logger log = LoggerFactory.getLogger(ViewerServiceImpl.class);
	/**
	 * the current D4SSession
	 * @return .
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		System.out.println("getASLSession COLLECTIONS");
		if (user == null) {
			user = "massimiliano.assante";
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);	
			session.setScope("/gcube/devsec");
			return session;
		}
		else
			return SessionManager.getInstance().getASLSession(sessionID, user);
	}

	/**
	 * 
	 */
	public List<CollectionBean> getAvailableCollections() {
		List<CollectionBean> toReturn = new ArrayList<CollectionBean>();

		log.debug("GETTING AVAILABLE COLLECTIONS" );

		try {
			//getting Tree Manager Collections

			Query query = new QueryBox("for $resource in collection('/db/Properties')//Document"
					+ " where $resource//Document/Data/child::*[local-name()='ServiceClass']/text() eq 'DataAccess' and "
					+ " $resource//Document/Data/child::*[local-name()='ServiceName']/text() eq 'tree-manager-service' "
					+ " return $resource");


			String currScope = 	ScopeProvider.instance.get();
			ScopeProvider.instance.set(getASLSession().getScope());

			DiscoveryClient<String> client = client();	
			List<String> results = client.submit(query);
			ScopeProvider.instance.set(currScope);
			for (String result : results) {
				DocumentBuilder docBuilder =  DocumentBuilderFactory.newInstance().newDocumentBuilder();
				Node node = docBuilder.parse(new InputSource(new StringReader(result))).getDocumentElement();
				XPathHelper helper = new XPathHelper(node);
				String name = (!helper.evaluate("//*[local-name()='"+"Name"+"']/text()").isEmpty()) ? helper.evaluate("//*[local-name()='"+"Name"+"']/text()").get(0) : "no name";
				String id = (!helper.evaluate("//*[local-name()='"+"SourceId"+"']/text()").isEmpty()) ?helper.evaluate("//*[local-name()='"+"SourceId"+"']/text()").get(0) : "no id";
				String totalItems = (helper.evaluate("//*[local-name()='"+"Cardinality"+"']/text()").size() > 0) ?  helper.evaluate("//*[local-name()='"+"Cardinality"+"']/text()").get(0) : "0";
				toReturn.add(new CollectionBean(id, name, "No Description Available, total items: " + totalItems, new Date(), "Tree Manager"));
			}


		} catch (Exception e) {
			e.printStackTrace();
			log.error("ERROR GETTING AVAILABLE COLLECTIONS" );
			toReturn.add(new CollectionBean("0000", "NO COLLECTION", "", new Date(), "Content Manager"));
			return toReturn;
		}
		//		
		log.trace("Printing COLLECTIONS" );
		for (CollectionBean collectionBean : toReturn) {
			log.trace("COLLECTION " + collectionBean.getName() + " FROM: " + collectionBean.getSource());
		}		




		log.debug("GOT AVAILABLE COLLECTIONS" );
		return toReturn;
	}


}
