/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.server;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContextEvent;
import org.gcube.portlets.user.dataminermanagertester.server.DataMinerTesterCallable;
import org.gcube.portlets.user.dataminermanagertester.server.task.TaskInProgress;
import org.gcube.portlets.user.dataminermanagertester.server.task.TaskRequest;
import org.gcube.portlets.user.dataminermanagertester.shared.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMinerTesterBatchDaemon
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(DataMinerTesterBatchDaemon.class);
    private long timeout = 1800000L;
    private long timeoutUpdate = 86400000L;
    private ServletContextEvent sce;
    private volatile boolean running = true;
    private ArrayList<TaskInProgress> tasks;
    private Timer threadPoolTimeoutUpdateTimer = null;

    public DataMinerTesterBatchDaemon(ServletContextEvent sce) {
        this.sce = sce;
        this.tasks = new ArrayList();
        this.initTimeout();
    }

    private void initTimeout() {
        this.sce.getServletContext().setAttribute("DATAMINERTESTER_MONITOR_TIME_OUT_PERIODMILLIS", (Object)this.timeout);
        this.retrieveTimeOut();
        this.startThreadPoolTimeoutUpdateTimer();
    }

    public void terminate() {
        this.running = false;
        if (this.threadPoolTimeoutUpdateTimer != null) {
            this.threadPoolTimeoutUpdateTimer.cancel();
        }
    }

    @Override
    public void run() {
        ConcurrentLinkedQueue jobQueue = new ConcurrentLinkedQueue();
        this.sce.getServletContext().setAttribute("TASK_REQUEST_QUEUE", jobQueue);
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        while (this.running) {
            while (!jobQueue.isEmpty()) {
                TaskRequest taskRequest = (TaskRequest)jobQueue.poll();
                DataMinerTesterCallable accountingClientCallable = new DataMinerTesterCallable(taskRequest);
                Future futureResult = executorService.submit(accountingClientCallable);
                TaskInProgress taskInProgress = new TaskInProgress((Calendar)new GregorianCalendar(), futureResult);
                this.tasks.add(taskInProgress);
            }
            if (!this.tasks.isEmpty()) {
                ArrayList<TaskInProgress> dones = new ArrayList<TaskInProgress>();
                for (TaskInProgress taskInProgress : this.tasks) {
                    Future futureResult = taskInProgress.getFuture();
                    if (futureResult.isDone()) {
                        TaskStatus result = null;
                        try {
                            result = (TaskStatus)futureResult.get(this.timeout, TimeUnit.MILLISECONDS);
                            logger.debug("DataMinerTesterTask: " + result);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            logger.error("DataMinerTesterTask: " + e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (TimeoutException e) {
                            logger.error("DataMinerTesterTask No response after " + this.timeout + " milliseconds!");
                            futureResult.cancel(true);
                        }
                        dones.add(taskInProgress);
                        continue;
                    }
                    GregorianCalendar now = new GregorianCalendar();
                    long diff = now.getTimeInMillis() - taskInProgress.getStartTime().getTimeInMillis();
                    if (diff <= this.timeout) continue;
                    futureResult.cancel(true);
                    dones.add(taskInProgress);
                }
                this.tasks.removeAll(dones);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void retrieveTimeOut() {
        long timeo = 0L;
        logger.info("DataMinerTester use default configuration for threadpool");
        timeo = 1800000L;
        if (timeo > 0L) {
            this.timeout = timeo;
            this.sce.getServletContext().setAttribute("DATAMINERTESTER_MONITOR_TIME_OUT_PERIODMILLIS", (Object)this.timeout);
        }
    }

    private void startThreadPoolTimeoutUpdateTimer() {
        try {
            this.threadPoolTimeoutUpdateTimer = new Timer();
            this.threadPoolTimeoutUpdateTimer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, this.timeoutUpdate, this.timeoutUpdate);
        }
        catch (Throwable e) {
            logger.error("Error retrieving thread pool timeout!", e);
            return;
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ void access$100(DataMinerTesterBatchDaemon x0) {
        x0.retrieveTimeOut();
    }
}

