/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.client.application.testbatchconfig;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.gwtplatform.mvp.client.ViewWithUiHandlers;
import gwt.material.design.client.base.constants.StyleName;
import gwt.material.design.client.base.density.Density;
import gwt.material.design.client.base.density.DisplayDensity;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.constants.TextAlign;
import gwt.material.design.client.data.SelectionType;
import gwt.material.design.client.ui.MaterialButton;
import gwt.material.design.client.ui.MaterialListBox;
import gwt.material.design.client.ui.MaterialTextArea;
import gwt.material.design.client.ui.MaterialTextBox;
import gwt.material.design.client.ui.animate.MaterialAnimation;
import gwt.material.design.client.ui.animate.Transition;
import gwt.material.design.client.ui.table.MaterialDataTable;
import gwt.material.design.client.ui.table.cell.Column;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import org.gcube.data.analysis.dataminermanagercl.shared.process.ComputationStatus;
import org.gcube.portlets.user.dataminermanagertester.client.application.testbatchconfig.TestBatchConfPresenter;
import org.gcube.portlets.user.dataminermanagertester.client.application.testbatchconfig.TestBatchConfUiHandlers;
import org.gcube.portlets.user.dataminermanagertester.client.application.testbatchconfig.TestBatchConfView;
import org.gcube.portlets.user.dataminermanagertester.shared.config.DMBatchConfig;
import org.gcube.portlets.user.dataminermanagertester.shared.config.ProtocolType;
import org.gcube.portlets.user.dataminermanagertester.shared.config.TestType;
import org.gcube.portlets.user.dataminermanagertester.shared.result.BatchTestRow;

class TestBatchConfView
extends ViewWithUiHandlers<TestBatchConfUiHandlers>
implements TestBatchConfPresenter.PresenterView {
    @UiField
    MaterialTextArea dms;
    @UiField
    MaterialTextBox token;
    @UiField
    MaterialListBox protocolType;
    @UiField
    MaterialListBox testType;
    @UiField
    MaterialTextArea result;
    @UiField
    MaterialDataTable<BatchTestRow> resultsTable;
    @UiField
    MaterialButton resultIcon;
    @UiField
    MaterialButton run;

    @Inject
    TestBatchConfView(Binder uiBinder) {
        this.initWidget((IsWidget)uiBinder.createAndBindUi((Object)this));
        this.testType.clear();
        for (TestType testType : TestType.values()) {
            this.testType.add((Object)testType.getLabel());
        }
        this.protocolType.clear();
        for (TestType testType : ProtocolType.values()) {
            this.protocolType.add((Object)testType.getLabel());
        }
        this.dms.setAllowBlank(false);
        this.token.setAllowBlank(false);
    }

    @UiHandler(value={"run"})
    void onClick(ClickEvent e) {
        ArrayList<Object> dmList;
        if (!this.dms.validate() || !this.token.validate()) {
            return;
        }
        String dmsValue = (String)this.dms.getValue();
        String tokenValue = (String)this.token.getValue();
        String protocolValue = this.protocolType.getValue();
        String testTypeValue = this.testType.getValue();
        this.resultIcon.setVisible(false);
        this.result.setVisible(false);
        this.resultsTable.setVisible(false);
        if (dmsValue.contains(",")) {
            String[] urlsArray = dmsValue.split(",");
            dmList = new ArrayList<String>(Arrays.asList(urlsArray));
            dmList.removeAll(Arrays.asList("", null));
        } else {
            dmList = new ArrayList<String>();
            dmList.add(dmsValue);
        }
        DMBatchConfig dmBatchConfig = new DMBatchConfig(dmList, tokenValue, protocolValue, testTypeValue);
        ((TestBatchConfUiHandlers)this.getUiHandlers()).executeBatchTest(dmBatchConfig);
    }

    public void setResult(String resultValue, boolean success) {
        this.resultIcon.setVisible(true);
        this.result.setVisible(true);
        if (success) {
            this.resultIcon.setIconType(IconType.CHECK_CIRCLE);
            this.resultIcon.setBackgroundColor(Color.GREEN);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        } else {
            this.resultIcon.setIconType(IconType.ERROR);
            this.resultIcon.setBackgroundColor(Color.RED);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        }
        MaterialAnimation animation = new MaterialAnimation();
        animation.setDelay(0);
        animation.setDuration(1000);
        animation.transition(Transition.FLIPINX);
        animation.animate((Widget)this.resultIcon);
        this.result.setLength(resultValue.length());
        this.result.setValue((Object)resultValue);
    }

    public void setupTable() {
        1 dataminerColumn = new /* Unavailable Anonymous Inner Class!! */;
        dataminerColumn.textAlign(TextAlign.LEFT);
        dataminerColumn.styleProperty(StyleName.WHITE_SPACE, "normal");
        2 statusColumn = new /* Unavailable Anonymous Inner Class!! */;
        statusColumn.textAlign(TextAlign.CENTER);
        3 responseColumn = new /* Unavailable Anonymous Inner Class!! */;
        responseColumn.textAlign(TextAlign.LEFT);
        this.resultsTable.addColumn("DataMiner", (Column)dataminerColumn);
        this.resultsTable.addColumn("Status", (Column)statusColumn);
        this.resultsTable.addColumn("Response", (Column)responseColumn);
    }

    public void setResultTable(ArrayList<BatchTestRow> batchTestRows) {
        this.resultIcon.setVisible(true);
        this.resultsTable.setVisible(true);
        boolean success = true;
        for (BatchTestRow batchTestRow : batchTestRows) {
            if (batchTestRow.getStatus() != null && batchTestRow.getStatus().compareTo((Enum)ComputationStatus.Status.COMPLETE) == 0) continue;
            success = false;
            break;
        }
        if (success) {
            this.resultIcon.setIconType(IconType.CHECK_CIRCLE);
            this.resultIcon.setBackgroundColor(Color.GREEN);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        } else {
            this.resultIcon.setIconType(IconType.ERROR);
            this.resultIcon.setBackgroundColor(Color.RED);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        }
        MaterialAnimation animation = new MaterialAnimation();
        animation.setDelay(0);
        animation.setDuration(1000);
        animation.transition(Transition.FLIPINX);
        animation.animate((Widget)this.resultIcon);
        this.resultsTable.clearRows(true);
        this.resultsTable.getTableTitle().setText("Results");
        this.resultsTable.setRowData(0, batchTestRows);
        this.resultsTable.getView().refresh();
        this.reload();
    }

    public void setupOptions() {
        this.resultsTable.setSelectionType(SelectionType.NONE);
        this.resultsTable.setDensity((Density)DisplayDensity.DEFAULT);
    }

    public void reload() {
        this.resultsTable.getView().setRedraw(true);
        this.resultsTable.getView().refresh();
    }
}

