/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.client.application.diff;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.gwtplatform.mvp.client.ViewWithUiHandlers;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.ui.MaterialButton;
import gwt.material.design.client.ui.MaterialListBox;
import gwt.material.design.client.ui.MaterialTextArea;
import gwt.material.design.client.ui.MaterialTextBox;
import gwt.material.design.client.ui.animate.MaterialAnimation;
import gwt.material.design.client.ui.animate.Transition;
import javax.inject.Inject;
import org.gcube.portlets.user.dataminermanagertester.client.application.diff.OperatorsDiffPresenter;
import org.gcube.portlets.user.dataminermanagertester.client.application.diff.OperatorsDiffUiHandlers;
import org.gcube.portlets.user.dataminermanagertester.client.application.diff.OperatorsDiffView;
import org.gcube.portlets.user.dataminermanagertester.shared.config.DMDiffConfig;
import org.gcube.portlets.user.dataminermanagertester.shared.config.ProtocolType;

class OperatorsDiffView
extends ViewWithUiHandlers<OperatorsDiffUiHandlers>
implements OperatorsDiffPresenter.PresenterView {
    @UiField
    MaterialTextBox dm1;
    @UiField
    MaterialTextBox token1;
    @UiField
    MaterialTextBox dm2;
    @UiField
    MaterialTextBox token2;
    @UiField
    MaterialListBox protocolType;
    @UiField
    MaterialTextArea result;
    @UiField
    MaterialButton resultIcon;
    @UiField
    MaterialButton run;

    @Inject
    OperatorsDiffView(Binder uiBinder) {
        this.initWidget((IsWidget)uiBinder.createAndBindUi((Object)this));
        this.protocolType.clear();
        for (ProtocolType tType : ProtocolType.values()) {
            this.protocolType.add((Object)tType.getLabel());
        }
        this.dm1.setAllowBlank(false);
        this.token1.setAllowBlank(false);
        this.dm2.setAllowBlank(false);
        this.token2.setAllowBlank(false);
    }

    @UiHandler(value={"run"})
    void onClick(ClickEvent e) {
        if (!(this.dm1.validate() && this.token1.validate() && this.dm2.validate() && this.token2.validate())) {
            return;
        }
        String dm1Value = (String)this.dm1.getValue();
        String token1Value = (String)this.token1.getValue();
        String dm2Value = (String)this.dm2.getValue();
        String token2Value = (String)this.token2.getValue();
        String protocolValue = this.protocolType.getValue();
        this.resultIcon.setVisible(false);
        this.result.setVisible(false);
        DMDiffConfig operatorsDiffConfig = new DMDiffConfig(dm1Value, token1Value, dm2Value, token2Value, protocolValue);
        ((OperatorsDiffUiHandlers)this.getUiHandlers()).executeDiff(operatorsDiffConfig);
    }

    public void setResult(String resultValue, boolean success) {
        this.resultIcon.setVisible(true);
        this.result.setVisible(true);
        if (success) {
            this.resultIcon.setIconType(IconType.CHECK_CIRCLE);
            this.resultIcon.setBackgroundColor(Color.GREEN);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        } else {
            this.resultIcon.setIconType(IconType.ERROR);
            this.resultIcon.setBackgroundColor(Color.RED);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        }
        MaterialAnimation animation = new MaterialAnimation();
        animation.setDelay(0);
        animation.setDuration(1000);
        animation.transition(Transition.FLIPINX);
        animation.animate((Widget)this.resultIcon);
        this.result.setLength(resultValue.length());
        this.result.setValue((Object)resultValue);
    }
}

