/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.server.storage;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.OpenResolver;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.data.analysis.dataminermanagercl.shared.workspace.ItemDescription;
import org.gcube.portlets.user.dataminermanager.server.storage.ItemDownload;
import org.gcube.portlets.user.dataminermanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtil {
    private static Logger logger = LoggerFactory.getLogger(StorageUtil.class);

    public Map<String, String> getProperties(String user, String itemId) throws ServiceException {
        try {
            StorageHubClient shc = new StorageHubClient();
            Item item = shc.open(itemId).asItem().get();
            Metadata metadata = item.getMetadata();
            HashMap<String, String> itemMap = new HashMap<String, String>();
            Map metadataMap = metadata.getMap();
            for (String key : metadataMap.keySet()) {
                String s = String.valueOf(metadataMap.get(key));
                itemMap.put(key, s);
            }
            return itemMap;
        }
        catch (Throwable e) {
            logger.error("Error retrieving properties: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    public InputStream getFileOnWorkspace(String user, String itemId) throws ServiceException {
        try {
            logger.debug("getInputStreamForItemOnWorkspace: [user=" + user + ", itemId=" + itemId + "]");
            StorageHubClient shc = new StorageHubClient();
            FileContainer fileContainer = shc.open(itemId).asFile();
            StreamDescriptor streamDescriptor = fileContainer.download(new String[0]);
            return streamDescriptor.getStream();
        }
        catch (Throwable e) {
            logger.error("Error retrieving InputStream for File: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    public ItemDownload getItemDownload(String user, String itemId) throws ServiceException {
        try {
            logger.debug("getItemDownload: [user=" + user + ", itemId=" + itemId + "]");
            StorageHubClient shc = new StorageHubClient();
            OpenResolver openResolver = shc.open(itemId);
            ItemContainer itemContainer = openResolver.asItem();
            Item item = itemContainer.get();
            StreamDescriptor streamDescriptor = null;
            if (item instanceof AbstractFileItem) {
                FileContainer fileContainer = openResolver.asFile();
                streamDescriptor = fileContainer.download(new String[0]);
            } else if (item instanceof FolderItem) {
                FolderContainer folderContainer = openResolver.asFolder();
                streamDescriptor = folderContainer.download(new String[0]);
            }
            if (streamDescriptor == null) {
                logger.error("This type of item does not support download: " + itemId);
                return null;
            }
            ItemDescription itemDescription = new ItemDescription(item.getId(), item.getName(), item.getOwner(), item.getPath(), this.getItemType(item));
            ItemDownload itemDownload = new ItemDownload(itemDescription, streamDescriptor.getStream());
            return itemDownload;
        }
        catch (Throwable e) {
            logger.error("Error retrieving InputStream for item: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    public ItemDescription getItemDescription(String user, String itemId) throws ServiceException {
        try {
            logger.info("Retrieve file info on workspace: [user=" + user + ", itemId=" + itemId + "]");
            StorageHubClient shc = new StorageHubClient();
            OpenResolver openResolver = shc.open(itemId);
            ItemContainer itemContainer = openResolver.asItem();
            Item item = itemContainer.get();
            ItemDescription itemDescription = new ItemDescription(item.getId(), item.getName(), item.getOwner(), item.getPath(), this.getItemType(item));
            return itemDescription;
        }
        catch (Throwable e) {
            logger.error("Retrieve file info on workspace: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public String getPublicLink(String user, String itemId) throws ServiceException {
        try {
            logger.debug("getPublicLink: [user=" + user + ", itemId=" + itemId + "]");
            StorageHubClient shc = new StorageHubClient();
            URL url = shc.open(itemId).asFile().getPublicLink();
            return url.toString();
        }
        catch (Throwable e) {
            logger.error("Error retrieving public link: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    public ItemDescription getItemInRootFolderOnWorkspace(String user, String itemName) throws ServiceException {
        try {
            logger.debug("GetItemInRootFolder: [user=" + user + ", itemName=" + itemName + "]");
            StorageHubClient shc = new StorageHubClient();
            ListResolver listResolver = shc.getWSRoot().findByName(itemName);
            List items = listResolver.getItems();
            if (items == null || items.isEmpty()) {
                logger.debug("No item found");
                return null;
            }
            Item item = (Item)items.get(0);
            logger.debug("Item: " + item);
            if (item != null) {
                logger.debug("Item Id=" + item.getId());
                ItemDescription itemDescription = new ItemDescription(item.getId(), item.getName(), item.getOwner(), item.getPath(), this.getItemType(item));
                return itemDescription;
            }
            return null;
        }
        catch (Throwable e) {
            logger.error("Error in get Item in RootFolder: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public ItemDescription getItemInFolderOnWorkspace(String user, String folderId, String itemName) throws ServiceException {
        try {
            logger.debug("GetItemInFolder: [user=" + user + ", folderId=" + folderId + ", itemName=" + itemName + "]");
            StorageHubClient shc = new StorageHubClient();
            ListResolver listResolver = shc.open(folderId).asFolder().findByName(itemName);
            List items = listResolver.getItems();
            if (items == null || items.isEmpty()) {
                logger.debug("No item found");
                return null;
            }
            Item item = (Item)items.get(0);
            logger.debug("Item: " + item);
            if (item != null) {
                logger.debug("Item Id=" + item.getId());
                ItemDescription itemDescription = new ItemDescription(item.getId(), item.getName(), item.getOwner(), item.getPath(), this.getItemType(item));
                return itemDescription;
            }
            return null;
        }
        catch (Throwable e) {
            logger.error("Error in get Item in Folder: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public void deleteItem(String user, String itemId) throws ServiceException {
        try {
            logger.debug("Delete Item: [User=" + user + ", ItemId=" + itemId + "]");
            StorageHubClient shc = new StorageHubClient();
            OpenResolver openResolver = shc.open(itemId);
            ItemContainer itemContainer = openResolver.asItem();
            itemContainer.delete();
            return;
        }
        catch (Throwable e) {
            logger.error("Error deleting Item: " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    private String getItemType(Item item) {
        if (item instanceof AbstractFileItem) {
            return AbstractFileItem.class.getSimpleName();
        }
        if (item instanceof FolderItem) {
            return FolderItem.class.getSimpleName();
        }
        if (item instanceof GCubeItem) {
            return GCubeItem.class.getSimpleName();
        }
        if (item instanceof TrashItem) {
            return TrashItem.class.getSimpleName();
        }
        return null;
    }
}

