/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.parametersfield;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.core.client.util.Format;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import java.util.ArrayList;
import java.util.Collection;
import org.gcube.data.analysis.dataminermanagercl.shared.data.ColumnItem;
import org.gcube.data.analysis.dataminermanagercl.shared.data.TableItemSimple;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ColumnParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.portlets.user.dataminermanager.client.events.TabularFldChangeEvent;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.AbstractFld;
import org.gcube.portlets.user.dataminermanager.client.properties.ColumnItemPropertiesCombo;

public class ColumnFld
extends AbstractFld
implements TabularFldChangeEvent.TabularFldChangeEventHandler {
    private String defaultColumn;
    private ComboBox<ColumnItem> comboBox;
    private ListStore<ColumnItem> store;
    private String referredTabularParameterName;
    private SimpleContainer fieldContainer;
    private SimpleContainer vContainer;

    public ColumnFld(Parameter parameter) {
        super(parameter);
        HtmlLayoutContainer descr;
        ColumnParameter columnParameter = (ColumnParameter)parameter;
        this.referredTabularParameterName = columnParameter.getReferredTabularParameterName();
        this.defaultColumn = columnParameter.getDefaultColumn();
        this.fieldContainer = new SimpleContainer();
        HBoxLayoutContainer horiz = new HBoxLayoutContainer();
        horiz.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        horiz.setEnableOverflow(false);
        ColumnItemPropertiesCombo props = (ColumnItemPropertiesCombo)GWT.create(ColumnItemPropertiesCombo.class);
        this.store = new ListStore(props.id());
        this.comboBox = new ComboBox(this.store, props.label());
        this.comboBox.setAllowBlank(false);
        this.comboBox.setForceSelection(true);
        this.comboBox.setEditable(false);
        this.comboBox.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.comboBox.setEnabled(false);
        if (columnParameter.getDescription() == null) {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'></p>");
            descr.addStyleName("workflow-fieldDescription");
        } else {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'>" + columnParameter.getDescription() + "</p>");
            descr.addStyleName("workflow-fieldDescription");
        }
        this.vContainer = new SimpleContainer();
        this.showNoSelectionField();
        horiz.add((IsWidget)this.vContainer, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        horiz.add((IsWidget)descr, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.fieldContainer.add((Widget)horiz);
        this.fieldContainer.forceLayout();
    }

    private void showNoSelectionField() {
        this.vContainer.clear();
        VerticalLayoutContainer vField = new VerticalLayoutContainer();
        HtmlLayoutContainer typeDescription = new HtmlLayoutContainer("<div class='workflow-parameters-description'><p>Select table from parameter " + Format.ellipse((String)this.referredTabularParameterName, (int)30) + "</p></div>");
        typeDescription.setStylePrimaryName("workflow-parameters-description");
        vField.add((IsWidget)this.comboBox, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vField.add((IsWidget)typeDescription, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.vContainer.add((Widget)vField);
    }

    private void showFieldWithSelection(TableItemSimple tableItem) {
        this.vContainer.clear();
        VerticalLayoutContainer vField = new VerticalLayoutContainer();
        HtmlLayoutContainer typeDescription = new HtmlLayoutContainer("<div class='workflow-parameters-description'><p>Columns of Table " + Format.ellipse((String)tableItem.getName(), (int)30) + "</p></div>");
        typeDescription.setStylePrimaryName("workflow-parameters-description");
        vField.add((IsWidget)this.comboBox, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vField.add((IsWidget)typeDescription, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.vContainer.add((Widget)vField);
    }

    public String getValue() {
        ColumnItem columnItem = (ColumnItem)this.comboBox.getCurrentValue();
        return columnItem != null ? columnItem.getName() : null;
    }

    public Widget getWidget() {
        return this.fieldContainer;
    }

    public boolean isValid() {
        return this.comboBox.isValid();
    }

    public void onChange(TabularFldChangeEvent event) {
        TableItemSimple tableItemSimple = event.getTableItemSimple();
        if (tableItemSimple == null) {
            this.store.clear();
            this.store.commitChanges();
            this.comboBox.clear();
            this.comboBox.setEnabled(false);
            this.showNoSelectionField();
        } else {
            this.store.clear();
            this.store.commitChanges();
            this.comboBox.clear();
            ArrayList columns = tableItemSimple.getColumns();
            if (columns != null) {
                this.store.addAll((Collection)columns);
                this.store.commitChanges();
                Log.debug((String)("DefaultColumn: " + this.defaultColumn));
                for (ColumnItem columnItem : columns) {
                    Log.debug((String)("ColumnItem: " + columnItem));
                    if (columnItem.getName().compareToIgnoreCase(this.defaultColumn) != 0) continue;
                    this.comboBox.setValue((Object)columnItem);
                    break;
                }
            }
            this.comboBox.setEnabled(true);
            this.showFieldWithSelection(tableItemSimple);
        }
        this.fieldContainer.forceLayout();
    }
}

