/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.experiments;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.util.Format;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.tips.ToolTipConfig;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorCategory;
import org.gcube.portlets.user.dataminermanager.client.experiments.OperatorPanel;
import org.gcube.portlets.user.dataminermanager.client.experiments.OperatorsPanelHandler;

public class OperatorCategoryPanel
extends SimpleContainer {
    private List<OperatorPanel> operatorPanelsList = null;
    private OperatorsPanelHandler handler;
    private static final int TOOLTIP_WIDTH = 300;
    private boolean isCollapsed = true;
    private OperatorCategory category;
    private HtmlLayoutContainer categoryHtml;
    private VerticalLayoutContainer v;

    public OperatorCategoryPanel(OperatorsPanelHandler handler, OperatorCategory operatorCategory) {
        this.handler = handler;
        this.category = operatorCategory;
        this.create();
    }

    public OperatorCategory getCategory() {
        return this.category;
    }

    private void create() {
        this.v = new VerticalLayoutContainer();
        this.add((Widget)this.v);
        this.categoryHtml = new HtmlLayoutContainer(this.category.getName() + " <span class='counter'>(" + this.category.getOperators().size() + ")</span>");
        this.categoryHtml.addStyleName("categoryItem");
        this.categoryHtml.addStyleName("categoryItem-Collapsed");
        ToolTipConfig tooltipConfig = this.createToolTip(this.category);
        this.categoryHtml.setToolTipConfig(tooltipConfig);
        this.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ClickEvent.getType());
        this.v.add((Widget)this.categoryHtml);
    }

    private ToolTipConfig createToolTip(OperatorCategory cat) {
        ToolTipConfig tooltipConfig = new ToolTipConfig();
        tooltipConfig.setTitleHtml("<br>&nbsp;&nbsp;" + cat.getName());
        tooltipConfig.setMouseOffsetX(0);
        tooltipConfig.setMouseOffsetY(0);
        tooltipConfig.setAnchor(Style.Side.LEFT);
        tooltipConfig.setDismissDelay(5000);
        tooltipConfig.setBodyHtml(this.getTooltipTemplate(GWT.getModuleBaseURL(), cat.getId(), cat.hasImage(), cat.getDescription()));
        tooltipConfig.setMaxWidth(300);
        return tooltipConfig;
    }

    private String getTooltipTemplate(String base, String id, boolean hasImage, String description) {
        String html = "<div class='categoryItemTooltip'><img src='" + base + "../images/categories/" + (hasImage ? id : "DEFAULT_IMAGE") + ".png' >" + Format.ellipse((String)description, (int)100) + "</div>";
        return html;
    }

    public void switchOpenClose() {
        if (this.isCollapsed) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    private void collapse() {
        this.categoryHtml.removeStyleName("categoryItem-Expanded");
        this.categoryHtml.addStyleName("categoryItem-Collapsed");
        for (OperatorPanel op : this.operatorPanelsList) {
            this.v.remove((Widget)op);
        }
        this.isCollapsed = true;
        this.forceLayout();
    }

    private void expand() {
        if (this.operatorPanelsList == null) {
            this.operatorPanelsList = new ArrayList();
            for (Operator op : this.category.getOperators()) {
                OperatorPanel operatorPanel = new OperatorPanel(op, this.handler);
                this.operatorPanelsList.add(operatorPanel);
            }
        }
        this.categoryHtml.removeStyleName("categoryItem-Collapsed");
        this.categoryHtml.addStyleName("categoryItem-Expanded");
        for (Operator op : this.operatorPanelsList) {
            this.v.add((Widget)op);
        }
        this.isCollapsed = false;
        this.forceLayout();
    }

    public void setDefaultOperator() {
        this.expand();
    }

    public void setOperatorDefault(Operator operatorDefault) {
        this.expand();
        for (OperatorPanel opPanel : this.operatorPanelsList) {
            if (opPanel.getOperator().compareTo(operatorDefault) != 0) continue;
            opPanel.setAsTheDefaultOperator();
            break;
        }
    }
}

