/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.computations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.XDOM;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValueFile;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationValueFilePanel;
import org.gcube.portlets.user.dataminermanager.client.widgets.ShowFileDialog;
import org.gcube.portlets.widgets.netcdfbasicwidgets.client.event.SelectVariableEvent;
import org.gcube.portlets.widgets.netcdfbasicwidgets.client.widgets.NetCDFPreviewDialog;

public class ComputationValueFilePanel
extends SimpleContainer {
    private ComputationValueFile computationValueFile;

    public ComputationValueFilePanel(ComputationValueFile computationValueFile) {
        this.computationValueFile = computationValueFile;
        this.init();
        this.create();
    }

    private void init() {
        this.setBorders(false);
    }

    private void create() {
        String fileNameLowerCase;
        VerticalLayoutContainer lc = new VerticalLayoutContainer();
        String fileName = this.computationValueFile.getFileName();
        String fileUrl = this.computationValueFile.getValue();
        HtmlLayoutContainer fileNameHtml = fileName != null ? new HtmlLayoutContainer("<div class='computation-output-fileName'><p>" + new SafeHtmlBuilder().appendEscaped(fileName).toSafeHtml().asString() + "</p></div>") : new HtmlLayoutContainer("<div class='computation-output-fileName'><p>" + new SafeHtmlBuilder().appendEscaped("NoName").toSafeHtml().asString() + "</p></div>");
        lc.add((IsWidget)fileNameHtml, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        TextButton showFileButton = new TextButton("Show");
        showFileButton.setIcon(DataMinerManager.resources.pageWhite());
        showFileButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton downloadBtn = new TextButton("Download");
        downloadBtn.setIcon(DataMinerManager.resources.download());
        downloadBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton netcdfButton = new TextButton("");
        netcdfButton.setIcon(DataMinerManager.resources.netcdf());
        netcdfButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer buttonsContainer = new HBoxLayoutContainer();
        buttonsContainer.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        BoxLayoutContainer.BoxLayoutData buttonBoxLayoutData = new BoxLayoutContainer.BoxLayoutData(new Margins(2, 2, 2, 2));
        if (fileName != null && !fileName.isEmpty() && ((fileNameLowerCase = fileName.toLowerCase()).endsWith(".html") || fileNameLowerCase.endsWith(".htm") || fileNameLowerCase.endsWith(".pdf") || fileNameLowerCase.endsWith(".log") || fileNameLowerCase.endsWith(".json") || fileNameLowerCase.endsWith(".txt"))) {
            buttonsContainer.add((IsWidget)showFileButton, buttonBoxLayoutData);
        }
        buttonsContainer.add((IsWidget)downloadBtn, buttonBoxLayoutData);
        if (this.computationValueFile.isNetcdf()) {
            buttonsContainer.add((IsWidget)netcdfButton, buttonBoxLayoutData);
        }
        lc.add((Widget)buttonsContainer);
        this.add((Widget)lc);
    }

    private void showFileCreate() {
        if (this.computationValueFile != null && this.computationValueFile.getValue() != null && !this.computationValueFile.getValue().isEmpty()) {
            GWT.log((String)"ShowFileCreate");
            ShowFileDialog showFileDialog = new ShowFileDialog(this.computationValueFile.getValue());
            showFileDialog.setZIndex(XDOM.getTopZIndex());
            showFileDialog.show();
        }
    }

    private void showNetCDFFile() {
        if (this.computationValueFile != null && this.computationValueFile.getValue() != null && !this.computationValueFile.getValue().isEmpty() && this.computationValueFile.isNetcdf()) {
            GWT.log((String)"NetcdfBasicWidgetsManager");
            4 handler = new /* Unavailable Anonymous Inner Class!! */;
            NetCDFPreviewDialog netcdfDialog = new NetCDFPreviewDialog(this.computationValueFile.getValue());
            netcdfDialog.addSelectVariableEventHandler((SelectVariableEvent.SelectVariableEventHandler)handler);
            netcdfDialog.setZIndex(XDOM.getTopZIndex());
        }
    }

    static /* synthetic */ void access$000(ComputationValueFilePanel x0) {
        x0.showFileCreate();
    }

    static /* synthetic */ void access$100(ComputationValueFilePanel x0) {
        x0.showNetCDFFile();
    }
}

