/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.server;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient4WPSBuilder;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClientBuilder;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClientDirector;
import org.gcube.data.analysis.dataminermanagercl.server.util.ServiceCredentials;
import org.gcube.portlets.user.dataminermanager.shared.exception.ServiceException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class SessionUtil {
    private static final Logger logger = Logger.getLogger(SessionUtil.class);

    public static ServiceCredentials getServiceCredentials(HttpServletRequest httpServletRequest) throws ServiceException {
        return SessionUtil.getServiceCredentials((HttpServletRequest)httpServletRequest, null);
    }

    public static ServiceCredentials getServiceCredentials(HttpServletRequest httpServletRequest, String scopeGroupId) throws ServiceException {
        ServiceCredentials sCredentials = null;
        String userName = null;
        String scope = null;
        String token = null;
        String groupId = null;
        String groupName = null;
        logger.debug((Object)"Retrieving credential in session!");
        PortalContext pContext = PortalContext.getConfiguration();
        boolean hasScopeGroupId = false;
        hasScopeGroupId = scopeGroupId != null && !scopeGroupId.isEmpty();
        scope = hasScopeGroupId ? pContext.getCurrentScope(scopeGroupId) : pContext.getCurrentScope(httpServletRequest);
        if (scope == null || scope.isEmpty()) {
            String error = "Error retrieving scope: " + scope;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        GCubeUser gCubeUser = pContext.getCurrentUser(httpServletRequest);
        if (gCubeUser == null) {
            String error = "Error retrieving gCubeUser in scope " + scope + ": " + gCubeUser;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        userName = gCubeUser.getUsername();
        if (userName == null || userName.isEmpty()) {
            String error = "Error retrieving username in scope " + scope + ": " + userName;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        token = pContext.getCurrentUserToken(scope, userName);
        if (token == null || token.isEmpty()) {
            String error = "Error retrieving token for " + userName + " in " + scope + ": " + token;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        String name = gCubeUser.getFirstName();
        String lastName = gCubeUser.getLastName();
        String fullName = gCubeUser.getFullname();
        String userAvatarURL = gCubeUser.getUserAvatarURL();
        String email = gCubeUser.getEmail();
        if (hasScopeGroupId) {
            GCubeGroup group;
            long gId;
            logger.debug((Object)("Set SecurityToken: " + token));
            SecurityTokenProvider.instance.set(token);
            logger.debug((Object)("Set ScopeProvider: " + scope));
            ScopeProvider.instance.set(scope);
            groupId = scopeGroupId;
            try {
                gId = Long.parseLong(scopeGroupId);
            }
            catch (Throwable e) {
                String error = "Error retrieving groupId: " + scopeGroupId;
                logger.error((Object)error, e);
                throw new ServiceException(error);
            }
            try {
                group = new LiferayGroupManager().getGroup(gId);
            }
            catch (Throwable e) {
                String error = "Error retrieving group: " + groupName;
                logger.error((Object)error);
                throw new ServiceException(error);
            }
            groupName = group.getGroupName();
        } else {
            groupId = String.valueOf(pContext.getCurrentGroupId(httpServletRequest));
            groupName = pContext.getCurrentGroupName(httpServletRequest);
        }
        sCredentials = new ServiceCredentials(userName, fullName, name, lastName, email, scope, groupId, groupName, userAvatarURL, token);
        logger.debug((Object)("ServiceCredentials: " + sCredentials));
        return sCredentials;
    }

    public static SClient getSClient(HttpServletRequest httpRequest, ServiceCredentials serviceCredentials) throws Exception {
        SClient sClient;
        if (serviceCredentials == null) {
            logger.error((Object)"ServiceCredentials is null!");
            throw new ServiceException("Service Credentials is null!");
        }
        HttpSession session = httpRequest.getSession();
        Object obj = session.getAttribute("DataMinerClientMap");
        if (obj == null) {
            logger.debug((Object)"Create new SClientMap");
            HashMap<String, SClient> sClientMap = new HashMap<String, SClient>();
            logger.debug((Object)"Create new SClient");
            SClient4WPSBuilder sBuilder = new SClient4WPSBuilder(serviceCredentials);
            SClientDirector director = new SClientDirector();
            director.setSClientBuilder((SClientBuilder)sBuilder);
            director.constructSClient();
            sClient = director.getSClient();
            sClientMap.put(serviceCredentials.getScope(), sClient);
            session.setAttribute("DataMinerClientMap", sClientMap);
        } else if (obj instanceof HashMap) {
            HashMap sClientMap = (HashMap)obj;
            if (sClientMap.containsKey(serviceCredentials.getScope())) {
                logger.debug((Object)"Use SClient in session");
                sClient = (SClient)sClientMap.get(serviceCredentials.getScope());
            } else {
                logger.debug((Object)"Create new SClient");
                SClient4WPSBuilder sBuilder = new SClient4WPSBuilder(serviceCredentials);
                SClientDirector director = new SClientDirector();
                director.setSClientBuilder((SClientBuilder)sBuilder);
                director.constructSClient();
                sClient = director.getSClient();
                sClientMap.put(serviceCredentials.getScope(), sClient);
                session.setAttribute("DataMinerClientMap", (Object)sClientMap);
            }
        } else {
            logger.error((Object)"Attention no SClientMap in Session!");
            throw new ServiceException("Sign Out, portlet is changed, a new session is required!");
        }
        return sClient;
    }
}

