/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.info;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.ScrollSupport;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridView;
import com.sencha.gxt.widget.core.client.grid.GroupingView;
import java.util.ArrayList;
import org.gcube.data.analysis.dataminermanagercl.shared.service.ServiceInfo;
import org.gcube.data.analysis.dataminermanagercl.shared.service.ServiceInfoData;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.events.ServiceInfoEvent;
import org.gcube.portlets.user.dataminermanager.client.events.ServiceInfoRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.info.ServiceInfoDataProperties;

public class ServiceInfoPanel
extends FramedPanel {
    private static final String RUNTIME_FEATURE = "Runtime features";
    private static final String SERVICE_INFO_TITLE = "Service Profile";
    private static final ServiceInfoDataProperties props = (ServiceInfoDataProperties)GWT.create(ServiceInfoDataProperties.class);
    private VerticalLayoutContainer v;
    private VerticalLayoutContainer environmentVBox;

    public ServiceInfoPanel() {
        Log.debug((String)"ServiceInfoPanel");
        this.init();
        this.create();
        this.bind();
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)new ServiceInfoRequestEvent());
    }

    private void init() {
        this.setItemId("ServiceInfoPanel");
        this.forceLayoutOnResize = true;
        this.setBodyBorder(false);
        this.setBorders(false);
        this.setBodyStyle("backgroundColor:white;");
        this.setHeaderVisible(false);
        this.setResize(true);
        this.setHeadingText(SERVICE_INFO_TITLE);
        this.setBodyStyle("backgroundColor:white;");
    }

    private void create() {
        try {
            this.v = new VerticalLayoutContainer();
            this.v.setScrollMode(ScrollSupport.ScrollMode.AUTO);
            this.add((Widget)this.v);
            this.createView();
            this.forceLayout();
        }
        catch (Throwable e) {
            Log.error((String)("Error creating ServiceInfoPanel: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void bind() {
        EventBusProvider.INSTANCE.addHandler(ServiceInfoEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createView() {
        SimpleContainer sectionTitle = new SimpleContainer();
        SimpleContainer sectionSubTitle = new SimpleContainer();
        HtmlLayoutContainer title = new HtmlLayoutContainer("<center style='font-size:16px;font-weight:bold;'>Service Profile</center>");
        sectionTitle.add((Widget)title, new MarginData());
        sectionTitle.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
        this.v.add((IsWidget)sectionTitle, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
        HtmlLayoutContainer subtitle = new HtmlLayoutContainer("<p style='font-size:12px;'>This page reports information on the DataMiner service instance serving this working environment giving an up to date picture of its capacities and capabilities.</p>");
        sectionSubTitle.add((Widget)subtitle, new MarginData());
        sectionSubTitle.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
        this.v.add((IsWidget)sectionSubTitle, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
    }

    private FieldSet environmentView() {
        try {
            this.environmentVBox = new VerticalLayoutContainer();
            FieldSet configurationFieldSet = new FieldSet();
            configurationFieldSet.setHeadingText(RUNTIME_FEATURE);
            configurationFieldSet.setCollapsible(true);
            configurationFieldSet.add((Widget)this.environmentVBox);
            configurationFieldSet.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
            return configurationFieldSet;
        }
        catch (Throwable e) {
            Log.error((String)("Error in ServiceInfoPanel in environment: " + e.getLocalizedMessage()), (Throwable)e);
            throw e;
        }
    }

    private void showAddress(String address) {
        SimpleContainer sectionServerAddress = new SimpleContainer();
        HtmlLayoutContainer addressHtml = new HtmlLayoutContainer("<p style='font-size:12px;'>The base url of the service instance is: <a href='" + address + "'>" + address + "</a></p>");
        sectionServerAddress.add((Widget)addressHtml, new MarginData());
        sectionServerAddress.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
        this.v.add((IsWidget)sectionServerAddress, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
    }

    private void showServiceInfo(ServiceInfo serviceInfo) {
        if (serviceInfo != null) {
            String address = serviceInfo.getServiceAddress();
            if (address != null && !address.isEmpty()) {
                this.showAddress(address);
            }
            FieldSet environmentFieldSet = this.environmentView();
            this.v.add((IsWidget)environmentFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
            ArrayList properties = serviceInfo.getServiceProperties();
            if (properties != null && !properties.isEmpty()) {
                Grid grid = this.createInfoGrid(properties);
                this.environmentVBox.add((IsWidget)grid, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            } else {
                HtmlLayoutContainer emptyInfoContainer = new HtmlLayoutContainer("<div class='service-property'><p>No Info Available.</p></div>");
                this.environmentVBox.add((IsWidget)emptyInfoContainer, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            }
        } else {
            FieldSet environmentFieldSet = this.environmentView();
            this.v.add((IsWidget)environmentFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
            HtmlLayoutContainer emptyInfoContainer = new HtmlLayoutContainer("<div class='service-property'><p>No Info Available.</p></div>");
            this.environmentVBox.add((IsWidget)emptyInfoContainer, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
        }
        this.forceLayout();
    }

    private Grid<ServiceInfoData> createInfoGrid(ArrayList<ServiceInfoData> properties) {
        ColumnConfig keyCol = new ColumnConfig(props.key(), 100, "Key");
        ColumnConfig valueCol = new ColumnConfig(props.value(), 100, "Value");
        ColumnConfig categoryCol = new ColumnConfig(props.category(), 100, "Category");
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        columns.add(keyCol);
        columns.add(valueCol);
        columns.add(categoryCol);
        ColumnModel cm = new ColumnModel(columns);
        ListStore store = new ListStore(props.id());
        store.addAll(properties);
        GroupingView groupingView = new GroupingView();
        groupingView.setShowGroupedColumn(false);
        groupingView.groupBy(categoryCol);
        groupingView.setForceFit(true);
        groupingView.setAutoExpandColumn(valueCol);
        groupingView.setEmptyText("No info retrieved");
        Grid grid = new Grid(store, cm, (GridView)groupingView);
        grid.setAllowTextSelection(true);
        grid.setBorders(false);
        grid.setColumnReordering(false);
        grid.setStateful(true);
        grid.setStateId("gridServiceInfoData");
        return grid;
    }

    static /* synthetic */ void access$000(ServiceInfoPanel x0, ServiceInfo x1) {
        x0.showServiceInfo(x1);
    }
}

