/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.data.analysis.dataminermanagercl.server.util.ServiceCredentials;
import org.gcube.portlets.user.dataminermanager.server.SessionUtil;
import org.gcube.portlets.user.dataminermanager.server.storage.ItemDownload;
import org.gcube.portlets.user.dataminermanager.server.storage.StorageUtil;
import org.gcube.portlets.user.dataminermanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 5389118370656932343L;
    private static Logger logger = LoggerFactory.getLogger(DownloadServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.createResponse(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.createResponse(request, response);
    }

    private void createResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String fileName;
            logger.debug("DownloadServlet()");
            HttpSession session = req.getSession();
            if (session == null) {
                logger.error("Error getting the download session, no session valid found: " + session);
                resp.sendError(500, "ERROR-Error getting the user session, no session found" + session);
                return;
            }
            logger.debug("DownloadServlet() session id: " + session.getId());
            String scopeGroupId = req.getHeader("CURR_GROUP_ID");
            if ((scopeGroupId == null || scopeGroupId.isEmpty()) && ((scopeGroupId = req.getParameter("CURR_GROUP_ID")) == null || scopeGroupId.isEmpty())) {
                logger.error("CURR_GROUP_ID is null, it is a mandatory parameter in custom servlet: " + scopeGroupId);
                throw new ServletException("CURR_GROUP_ID is null, it is a mandatory parameter in custom servlet: " + scopeGroupId);
            }
            String itemId = req.getParameter("itemId");
            logger.info("DownloadServlet(): [scopeGroupId=" + scopeGroupId + ",ItemId=" + itemId + "]");
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)req, (String)scopeGroupId);
            StorageUtil filesStorage = new StorageUtil();
            ItemDownload itemDownload = filesStorage.getItemDownload(serviceCredentials.getUserName(), itemId);
            logger.debug("ItemDownload: " + itemDownload);
            if (itemDownload == null) {
                logger.error("This type of item does not support download operation");
                throw new ServletException("This type of item does not support download operation");
            }
            if (itemDownload.getInputStream() == null) {
                logger.error("This type of item does not support download operation");
                throw new ServletException("This type of item does not support download operation");
            }
            if (itemDownload.getItemDescription() == null) {
                fileName = "filename";
                resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
                resp.setHeader("Content-Type", "application/force-download");
            } else if (itemDownload.getItemDescription().getName() == null || itemDownload.getItemDescription().getName().isEmpty()) {
                if (itemDownload.getItemDescription().getType() != null && itemDownload.getItemDescription().getType().compareTo(FolderItem.class.getSimpleName()) == 0) {
                    fileName = "folder.zip";
                    resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
                    resp.setHeader("Content-Type", "application/zip");
                } else {
                    fileName = "filename";
                    resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
                    resp.setHeader("Content-Type", "application/force-download");
                }
            } else if (itemDownload.getItemDescription().getType() != null && itemDownload.getItemDescription().getType().compareTo(FolderItem.class.getSimpleName()) == 0) {
                fileName = itemDownload.getItemDescription().getName() + ".zip";
                resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
                resp.setHeader("Content-Type", "application/zip");
            } else {
                fileName = itemDownload.getItemDescription().getName();
                resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
                resp.setHeader("Content-Type", "application/force-download");
            }
            logger.debug("Content-Disposition: " + resp.getHeader("Content-Disposition"));
            logger.debug("Content-Type: " + resp.getHeader("Content-Type"));
            logger.debug("DownloadServlet filename: " + fileName);
            this.stream(itemDownload.getInputStream(), (OutputStream)resp.getOutputStream());
        }
        catch (ServiceException e) {
            logger.error("DownloadServlet():" + e.getLocalizedMessage(), (Throwable)e);
            throw new ServletException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("DownloadServlet(): " + e.getLocalizedMessage(), e);
            throw new ServletException("Download item error: " + e.getLocalizedMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    private long stream(InputStream input, OutputStream output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

