/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.parametersfield;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.core.client.util.Format;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import org.gcube.data.analysis.dataminermanagercl.shared.data.ColumnItem;
import org.gcube.data.analysis.dataminermanagercl.shared.data.TableItemSimple;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ColumnListParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.portlets.user.dataminermanager.client.events.TabularFldChangeEvent;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.AbstractFld;
import org.gcube.portlets.user.dataminermanager.client.properties.ColumnItemProperties;

public class ColumnListFld
extends AbstractFld
implements TabularFldChangeEvent.TabularFldChangeEventHandler {
    private ColumnListParameter columnListParameter;
    private ListStore<ColumnItem> store;
    private Grid<ColumnItem> grid;
    private CheckBoxSelectionModel<ColumnItem> sm;
    private SimpleContainer fieldContainer;
    private SimpleContainer vContainer;

    public ColumnListFld(Parameter parameter) {
        super(parameter);
        HtmlLayoutContainer descr;
        this.columnListParameter = (ColumnListParameter)parameter;
        this.fieldContainer = new SimpleContainer();
        HBoxLayoutContainer horiz = new HBoxLayoutContainer();
        horiz.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        horiz.setEnableOverflow(false);
        this.createGrid();
        if (this.columnListParameter.getDescription() == null) {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'></p>");
            descr.addStyleName("workflow-fieldDescription");
        } else {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'>" + this.columnListParameter.getDescription() + "</p>");
            descr.addStyleName("workflow-fieldDescription");
        }
        this.vContainer = new SimpleContainer();
        this.showNoSelectionField();
        horiz.add((IsWidget)this.vContainer, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        horiz.add((IsWidget)descr, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.fieldContainer.add((Widget)horiz);
        this.fieldContainer.forceLayout();
    }

    private void createGrid() {
        ColumnItemProperties props = (ColumnItemProperties)GWT.create(ColumnItemProperties.class);
        ColumnConfig labelCol = new ColumnConfig(props.label());
        labelCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        IdentityValueProvider identity = new IdentityValueProvider();
        this.sm = new CheckBoxSelectionModel((ValueProvider)identity);
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(this.sm.getColumn());
        l.add(labelCol);
        ColumnModel cm = new ColumnModel(l);
        this.store = new ListStore(props.id());
        this.grid = new Grid(this.store, cm);
        this.sm.setSelectionMode(Style.SelectionMode.MULTI);
        this.grid.setSelectionModel((GridSelectionModel)this.sm);
        this.grid.setSize("180px", "150px");
        this.grid.getView().setStripeRows(true);
        this.grid.getView().setColumnLines(true);
        this.grid.getView().setAutoFill(true);
        this.grid.setBorders(false);
        this.grid.setLoadMask(true);
        this.grid.setColumnReordering(true);
        this.grid.setColumnResize(false);
        this.grid.disable();
    }

    private void showNoSelectionField() {
        this.vContainer.clear();
        VerticalLayoutContainer vField = new VerticalLayoutContainer();
        HtmlLayoutContainer typeDescription = new HtmlLayoutContainer("<div class='workflow-parameters-description'><p>Select table from parameter " + Format.ellipse((String)this.columnListParameter.getReferredTabularParameterName(), (int)30) + "</p></div>");
        typeDescription.setStylePrimaryName("workflow-parameters-description");
        vField.add((IsWidget)this.grid, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        vField.add((IsWidget)typeDescription, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.vContainer.add((Widget)vField);
    }

    private void showFieldWithSelection(TableItemSimple tableItem) {
        this.vContainer.clear();
        VerticalLayoutContainer vField = new VerticalLayoutContainer();
        HtmlLayoutContainer typeDescription = new HtmlLayoutContainer("<div class='workflow-parameters-description'><p>Columns of Table " + Format.ellipse((String)tableItem.getName(), (int)30) + "</p></div>");
        typeDescription.setStylePrimaryName("workflow-parameters-description");
        vField.add((IsWidget)this.grid, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        vField.add((IsWidget)typeDescription, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.vContainer.add((Widget)vField);
    }

    public String getValue() {
        String separator = this.columnListParameter.getSeparator();
        String value = "";
        boolean first = true;
        for (ColumnItem columnItem : this.sm.getSelection()) {
            String columnName = columnItem.getName();
            value = value + (first ? "" : separator) + columnName;
            first = false;
        }
        return value;
    }

    public Widget getWidget() {
        return this.fieldContainer;
    }

    public boolean isValid() {
        return this.sm.getSelection() != null && this.sm.getSelection().size() > 0;
    }

    public void onChange(TabularFldChangeEvent event) {
        TableItemSimple tableItemSimple = event.getTableItemSimple();
        if (tableItemSimple == null) {
            this.store.clear();
            this.store.commitChanges();
            this.grid.disable();
            this.showNoSelectionField();
        } else {
            this.store.clear();
            this.store.commitChanges();
            this.store.addAll((Collection)tableItemSimple.getColumns());
            this.store.commitChanges();
            this.grid.enable();
            this.showFieldWithSelection(tableItemSimple);
        }
    }
}

