/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.widgets;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.XDOM;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.FileResource;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.widgets.FileViewer;
import org.gcube.portlets.user.dataminermanager.client.widgets.ShowFileDialog;
import org.gcube.portlets.widgets.netcdfbasicwidgets.client.event.SelectVariableEvent;
import org.gcube.portlets.widgets.netcdfbasicwidgets.client.widgets.NetCDFPreviewDialog;

public class FileViewer
extends SimpleContainer {
    private FileResource fileResource;

    public FileViewer(ComputationId computationId, FileResource fileResource) {
        GWT.log((String)("FileViewer: [computationId=" + computationId + ", fileResource=" + fileResource + "]"));
        this.fileResource = fileResource;
        this.init();
        this.create();
    }

    private void init() {
        this.setHeight(56);
    }

    private void create() {
        String fileNameLowerCase;
        VerticalLayoutContainer lc = new VerticalLayoutContainer();
        String fileName = this.fileResource.getName();
        String fileDescription = this.fileResource.getDescription();
        String fileUrl = this.fileResource.getUrl();
        if (fileDescription == null || fileDescription.isEmpty()) {
            fileDescription = "Unknow";
        }
        HtmlLayoutContainer fileNameHtml = new HtmlLayoutContainer("<div class='computation-output-fileName'><p>" + new SafeHtmlBuilder().appendEscaped(fileDescription).toSafeHtml().asString() + "</p></div>");
        lc.add((IsWidget)fileNameHtml, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        TextButton showFileButton = new TextButton("Show");
        showFileButton.setIcon(DataMinerManager.resources.pageWhite());
        showFileButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton downloadButton = new TextButton("Download");
        downloadButton.setIcon(DataMinerManager.resources.download());
        downloadButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton netcdfButton = new TextButton("");
        netcdfButton.setIcon(DataMinerManager.resources.netcdf());
        netcdfButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer buttonsContainer = new HBoxLayoutContainer();
        buttonsContainer.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        BoxLayoutContainer.BoxLayoutData buttonBoxLayoutData = new BoxLayoutContainer.BoxLayoutData(new Margins(2, 2, 2, 2));
        if (fileName != null && !fileName.isEmpty() && ((fileNameLowerCase = fileName.toLowerCase()).endsWith(".html") || fileNameLowerCase.endsWith(".htm") || fileNameLowerCase.endsWith(".pdf") || fileNameLowerCase.endsWith(".log") || fileNameLowerCase.endsWith(".json") || fileNameLowerCase.endsWith(".txt"))) {
            buttonsContainer.add((IsWidget)showFileButton, buttonBoxLayoutData);
        }
        buttonsContainer.add((IsWidget)downloadButton, buttonBoxLayoutData);
        if (this.fileResource.isNetcdf()) {
            buttonsContainer.add((IsWidget)netcdfButton, buttonBoxLayoutData);
        }
        lc.add((Widget)buttonsContainer);
        this.add((Widget)lc);
    }

    private void showFileCreate() {
        if (this.fileResource != null && this.fileResource.getUrl() != null && !this.fileResource.getUrl().isEmpty()) {
            GWT.log((String)"ShowFileCreate");
            ShowFileDialog showFileDialog = new ShowFileDialog(this.fileResource.getUrl());
            showFileDialog.setZIndex(XDOM.getTopZIndex());
            showFileDialog.show();
        }
    }

    private void showNetCDFFile() {
        if (this.fileResource != null && this.fileResource.getUrl() != null && !this.fileResource.getUrl().isEmpty() && this.fileResource.isNetcdf()) {
            GWT.log((String)"NetcdfBasicWidgetsManager");
            4 handler = new /* Unavailable Anonymous Inner Class!! */;
            NetCDFPreviewDialog netcdfDialog = new NetCDFPreviewDialog(this.fileResource.getUrl());
            netcdfDialog.addSelectVariableEventHandler((SelectVariableEvent.SelectVariableEventHandler)handler);
            netcdfDialog.setZIndex(XDOM.getTopZIndex());
        }
    }

    static /* synthetic */ void access$000(FileViewer x0) {
        x0.showFileCreate();
    }

    static /* synthetic */ void access$100(FileViewer x0) {
        x0.showNetCDFFile();
    }
}

