/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.parametersfield;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.sencha.gxt.core.client.dom.XDOM;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.TextField;
import org.gcube.data.analysis.dataminermanagercl.shared.data.TableItemSimple;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.TabularParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.workspace.ItemDescription;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TabItem;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TabularListFld;
import org.gcube.portlets.user.dataminermanager.client.rpc.DataMinerPortletServiceAsync;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;
import org.gcube.portlets.user.dataminermanager.client.workspace.DownloadWidget;
import org.gcube.portlets.widgets.wsexplorer.client.notification.WorkspaceExplorerSelectNotification;
import org.gcube.portlets.widgets.wsexplorer.client.select.WorkspaceExplorerSelectDialog;
import org.gcube.portlets.widgets.wsexplorer.shared.Item;

public class TabItem
extends HBoxLayoutContainer {
    private TabularListFld parent;
    private TextButton selectButton;
    private TextButton selectButton2;
    private TableItemSimple selectedTableItem;
    private TextButton addBtn;
    private TextButton removeBtn;
    private TextField tableDescription;
    private WorkspaceExplorerSelectDialog wselectDialog;
    private TextButton downloadButton;
    private ItemDescription itemDescriptionSelected;

    public TabItem(TabularListFld parent, TabularParameter tabularParameter, boolean first) {
        this.parent = parent;
        this.initDialog();
        this.create(tabularParameter, first);
    }

    private void create(TabularParameter tabularParameter, boolean first) {
        this.tableDescription = new TextField();
        this.tableDescription.setReadOnly(true);
        this.tableDescription.setVisible(false);
        this.selectButton = new TextButton("Select Data Set");
        this.selectButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.selectButton.setIcon(DataMinerManager.resources.folderExplore());
        this.selectButton.setToolTip("Select Data Set");
        this.selectButton2 = new TextButton("");
        this.selectButton2.setIcon(DataMinerManager.resources.folderExplore());
        this.selectButton2.setToolTip("Select Another Data Set");
        this.selectButton2.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.selectButton2.setVisible(false);
        this.downloadButton = new TextButton("");
        this.downloadButton.setIcon(DataMinerManager.resources.download());
        this.downloadButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadButton.setVisible(false);
        this.addBtn = new TextButton("");
        this.addBtn.setIcon(DataMinerManager.resources.add());
        this.addBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn = new TextButton("");
        this.removeBtn.setIcon(DataMinerManager.resources.cancel());
        this.removeBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.setVisible(!first);
        this.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        this.setEnableOverflow(false);
        this.add((IsWidget)this.tableDescription, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.add((IsWidget)this.selectButton, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.add((IsWidget)this.selectButton2, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.add((IsWidget)this.downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.add((IsWidget)this.addBtn, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.add((IsWidget)this.removeBtn, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.forceLayout();
    }

    private void initDialog() {
        this.wselectDialog = new WorkspaceExplorerSelectDialog("Select CSV", false);
        6 handler = new /* Unavailable Anonymous Inner Class!! */;
        this.wselectDialog.addWorkspaceExplorerSelectNotificationListener((WorkspaceExplorerSelectNotification.WorskpaceExplorerSelectNotificationListener)handler);
        this.wselectDialog.setZIndex(XDOM.getTopZIndex());
    }

    private void retrieveTableInformation(Item item) {
        Log.debug((String)("Retrieved: " + item));
        this.itemDescriptionSelected = new ItemDescription(item.getId(), item.getName(), item.getOwner(), item.getPath(), item.getType().name());
        DataMinerPortletServiceAsync.INSTANCE.retrieveTableInformation(this.itemDescriptionSelected, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void downloadFile() {
        if (this.itemDescriptionSelected != null) {
            DownloadWidget downloadWidget = new DownloadWidget();
            downloadWidget.download(this.itemDescriptionSelected.getId());
        } else {
            UtilsGXT3.info((String)"Attention", (String)"Select a table!");
        }
    }

    private void showFieldWithSelection() {
        try {
            String tableName = this.selectedTableItem.getName();
            if (tableName == null || tableName.isEmpty()) {
                tableName = "NoName";
            }
            this.tableDescription.setValue((Object)tableName);
            this.tableDescription.setVisible(true);
            this.selectButton.setVisible(false);
            this.selectButton2.setVisible(true);
            this.downloadButton.setVisible(true);
            this.parent.forceLayout();
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void showCancelButton() {
        this.removeBtn.setVisible(true);
    }

    public void hideCancelButton() {
        this.removeBtn.setVisible(false);
    }

    public String getValue() {
        return this.selectedTableItem == null ? null : this.selectedTableItem.getId();
    }

    public boolean isValid() {
        return this.selectedTableItem != null;
    }

    static /* synthetic */ WorkspaceExplorerSelectDialog access$000(TabItem x0) {
        return x0.wselectDialog;
    }

    static /* synthetic */ void access$100(TabItem x0) {
        x0.downloadFile();
    }

    static /* synthetic */ TabularListFld access$200(TabItem x0) {
        return x0.parent;
    }

    static /* synthetic */ TableItemSimple access$302(TabItem x0, TableItemSimple x1) {
        x0.selectedTableItem = x1;
        return x0.selectedTableItem;
    }

    static /* synthetic */ void access$400(TabItem x0, Item x1) {
        x0.retrieveTableInformation(x1);
    }

    static /* synthetic */ void access$500(TabItem x0) {
        x0.showFieldWithSelection();
    }
}

