/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.computations;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.widget.core.client.TabItemConfig;
import com.sencha.gxt.widget.core.client.TabPanel;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import java.util.ArrayList;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationsExecutedPanel;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationsPanel;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationsViewerPanel;
import org.gcube.portlets.user.dataminermanager.client.events.ComputationDataEvent;
import org.gcube.portlets.user.dataminermanager.client.events.DataMinerWorkAreaEvent;
import org.gcube.portlets.user.dataminermanager.client.events.RefreshDataMinerWorkAreaEvent;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;

public class ComputationsPanel
extends SimpleContainer {
    private ArrayList<ComputationsViewerPanel> computationsViewers;
    private ComputationsExecutedPanel computationsExecutedPanel;
    private TabPanel computationsTabPanel;

    public ComputationsPanel() {
        Log.debug((String)"ComputationsPanel");
        this.init();
        this.create();
        this.bind();
    }

    private void init() {
    }

    private void bind() {
        EventBusProvider.INSTANCE.addHandler(ComputationDataEvent.getType(), (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(DataMinerWorkAreaEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(RefreshDataMinerWorkAreaEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void manageDataMinerWorkAreaEvents(DataMinerWorkAreaEvent event) {
        Log.debug((String)("ComputationsPanel recieved DataMinerWorkAreaEvent: " + event));
        if (event == null) {
            Log.error((String)"DataMinerWorkAreaEvent null");
            return;
        }
        switch (4.$SwitchMap$org$gcube$portlets$user$dataminermanager$client$type$DataMinerWorkAreaRegionType[event.getDataMinerWorkAreaRegionType().ordinal()]) {
            case 1: {
                this.closeAllComputationsViewer();
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void manageRefreshDataMinerWorkAreaEvents(RefreshDataMinerWorkAreaEvent event) {
        Log.debug((String)("ComputationsPanel recieved RefreshDataMinerWorkAreaEvent: " + event));
        if (event == null) {
            Log.error((String)"RefreshDataMinerWorkAreaEvent null");
            return;
        }
        switch (4.$SwitchMap$org$gcube$portlets$user$dataminermanager$client$type$DataMinerWorkAreaElementType[event.getDataMinerWorkAreaElementType().ordinal()]) {
            case 1: {
                this.closeAllComputationsViewer();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void create() {
        this.computationsViewers = new ArrayList();
        this.computationsExecutedPanel = new ComputationsExecutedPanel();
        this.computationsTabPanel = new TabPanel();
        this.computationsTabPanel.setTabScroll(true);
        this.computationsTabPanel.setBorders(false);
        this.computationsTabPanel.setBodyBorder(false);
        TabItemConfig computationsExecutedItemConf = new TabItemConfig("List of Computations", false);
        computationsExecutedItemConf.setIcon(DataMinerManager.resources.folderExplore());
        this.computationsTabPanel.add((Widget)this.computationsExecutedPanel, computationsExecutedItemConf);
        this.computationsTabPanel.setActiveWidget((Widget)this.computationsExecutedPanel);
        this.add((Widget)this.computationsTabPanel, new MarginData(0));
    }

    private void addComputationsViewerPanel(ComputationDataEvent event) {
        if (event == null || event.getComputationData() == null) {
            Log.error((String)("Invalid ComputationDataEvent: " + event));
            UtilsGXT3.alert((String)"Error", (String)("Invalid ComputationDataEvent: " + event));
            return;
        }
        if (event.getComputationData().getComputationId() == null) {
            Log.error((String)("Invalid ComputationId: " + event.getComputationData().getComputationId()));
            UtilsGXT3.alert((String)"Error", (String)("Invalid ComputationId: " + event.getComputationData().getComputationId()));
            return;
        }
        if (event.getComputationData().getComputationId().getId() == null || event.getComputationData().getComputationId().getId().isEmpty()) {
            Log.error((String)("Invalid Computation id: " + event.getComputationData().getComputationId().getId()));
            UtilsGXT3.alert((String)"Error", (String)("Invalid Computation id: " + event.getComputationData().getComputationId().getId()));
            return;
        }
        ComputationsViewerPanel computationsViewerPanel = new ComputationsViewerPanel(event.getComputationData());
        this.computationsViewers.add(computationsViewerPanel);
        TabItemConfig computationsViewerItemConf = new TabItemConfig(event.getComputationData().getComputationId().getId(), true);
        computationsViewerItemConf.setIcon(DataMinerManager.resources.folderExplore());
        this.computationsTabPanel.add((Widget)computationsViewerPanel, computationsViewerItemConf);
        this.computationsTabPanel.setActiveWidget((Widget)computationsViewerPanel);
        this.computationsTabPanel.forceLayout();
        this.forceLayout();
    }

    private void closeAllComputationsViewer() {
        for (ComputationsViewerPanel view : this.computationsViewers) {
            if (this.computationsTabPanel.getWidgetIndex((Widget)view) == -1) continue;
            this.computationsTabPanel.remove((Widget)view);
        }
        this.computationsViewers.clear();
        this.computationsTabPanel.forceLayout();
        this.forceLayout();
    }

    static /* synthetic */ void access$000(ComputationsPanel x0, ComputationDataEvent x1) {
        x0.addComputationsViewerPanel(x1);
    }

    static /* synthetic */ void access$100(ComputationsPanel x0, DataMinerWorkAreaEvent x1) {
        x0.manageDataMinerWorkAreaEvents(x1);
    }

    static /* synthetic */ void access$200(ComputationsPanel x0, RefreshDataMinerWorkAreaEvent x1) {
        x0.manageRefreshDataMinerWorkAreaEvents(x1);
    }
}

