package org.gcube.portlets.user.gcubeloggedin.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.gcubeloggedin.client.LoggedinService;
import org.gcube.portlets.user.gcubeloggedin.shared.VObject;
import org.gcube.portlets.user.gcubeloggedin.shared.VObject.UserBelongingClient;
import org.gcube.portlets.user.gcubeloggedin.shared.VREClient;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class LoggedinServiceImpl extends RemoteServiceServlet implements LoggedinService {

	private static GCUBEClientLog _log = new GCUBEClientLog(LoggedinServiceImpl.class);
	private boolean isDeployed = true;
	/**
	 * the current ASLSession
	 * @return .
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			_log.warn("LOGGEDIN PORTLET: USER IS NULL \n\n SESSION ID READ: " +sessionID );
			user = "test.user";
			_log.warn("session ID= *" + sessionID + "*  user= *" + user + "*" );		
			isDeployed = false;
		}

		return SessionManager.getInstance().getASLSession(sessionID, user);

	}
	/**
	 * return the current selected VRE
	 */

	public VObject getSelectedRE() {
		ASLSession aslSession = getASLSession();
		if (! isDeployed) {
			return new VREClient("Test", "", "" +
					"Fishery and Aquaculture Resources Management (FARM) Virtual Organisation</b>    The FARM Virtual Organisation is the <b><i>dynamic group of individuals</i></b> and/or <b><i>institutions</i></b>             defined around a set of <b><i>sharing rules</i></b> in which <b><i>resource providers</i></b> and <b><i>consumers</i></b>     specify clearly and carefully just what is shared, who is allowed to share, and the conditions under which sharing occurs to serve the needs of the     <b><i>Fisheries and Aquaculture Resources Management</i></b>.             This VO is conceived to support various application scenarios arising in the FARM Community including the production of Fisheries and Aquaculture Country Profiles, the management of catch statistics    including harmonisation, the dynamic generation of biodiversity maps and species distribution maps.            This Virtual Organisation currently consists of:<ul>                <li> approximately <b><i>13 gCube nodes</i></b>, i.e. machines dedicated to run the gCube system;</li>        <li> approximately <b><i>89 running instances</i></b>, i.e. running gCube services supporting the operation of the infrastructure;</li>        <li> approximately <b><i>25 collections</i></b>, i.e. set of D4Science Information Objects including Earth images, AquaMaps, Graphs on catch statistics;</li>        <li> approximately <b><i>66 metadata collections</i></b>, i.e. set of Metadata Objects describing the Information Objects through various features and schemas;</li>        <li> approximately <b><i>58 other resources</i></b> including transformation programs, index types, etc.</li></ul></div>" +
					"", "", "", UserBelongingClient.BELONGING);
		}
		_log.trace("getting Selected Research Environment");
		HttpSession session = this.getThreadLocalRequest().getSession();		
		ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);
		Organization currOrg  = (Organization) session.getAttribute("CURR_RE_NAME");

		/**
		 * set the current ORG bean in session
		 */
		aslSession.setAttribute(ScopeHelper.CURR_ORG, currOrg);

		aslSession.setGroupModelInfos(currOrg.getName(), currOrg.getOrganizationId());

		_log.trace("CURRENT ORG SET IN SESSION: " + currOrg.getName());


		String name = currOrg.getName();
		long logoId = currOrg.getLogoId();
		String logoURL =  themeDisplay.getPathImage()+"/organization_logo?img_id="+ logoId +"&t" + ImageServletTokenUtil.getToken(logoId);
		String desc = "";
		//set the description for the vre
		if (currOrg.getComments() != null)	
			desc = currOrg.getComments();
		VREClient vre = new VREClient(name, "", desc, logoURL, "", UserBelongingClient.BELONGING);
		setVREBelonginApplication(vre);
		return vre;
	}


	/**
	 * recursive method which list the portlets belonging to the current VO/VRE whole layout
	 * 
	 * @param layouts
	 * @param themeDisplay
	 * @param belongingPortletNames
	 * @throws SystemException
	 */
	private void findLayoutPortlets(List<Layout> layouts, ThemeDisplay themeDisplay, List<String> belongingPortletNames ) throws SystemException {
		if (layouts == null)
			return;
		for (Layout curLayout : layouts) {			
			LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)curLayout.getLayoutType();
			List<String> actualPortletList = layoutTypePortlet.getPortletIds();
			for (String portletID : actualPortletList) {
				String pname = LanguageUtil.get(themeDisplay.getLocale(), portletID);	
				//adding the portlet name cutting the not need part e.g. WorkspacePortlet_WAR_WorkspacePortlet
				if (pname.indexOf("WAR") > 0) {
					pname = pname.substring(0, pname.indexOf("WAR")-1);
				} 
				belongingPortletNames.add(pname);
			}	
			findLayoutPortlets(curLayout.getChildren(), themeDisplay, belongingPortletNames);
		}		
	}

	/**
	 * TODO: Look which portlets are in the current VRE layout and create a List of names with them
	 * @param vre
	 */
	private void setVREBelonginApplication(VREClient vre) {

		List<String> belongingPortletNames = new ArrayList<String>();		
		ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);

		_log.debug("Reading Layouts...");

		List<Layout> layouts = themeDisplay.getLayouts();		
		try {
			findLayoutPortlets(layouts, themeDisplay, belongingPortletNames);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		Collections.sort(belongingPortletNames);
		_log.debug("AvailablePortlets STORE IN SESSION \n" + belongingPortletNames.toString());
		getASLSession().setAttribute("availablePortlets", belongingPortletNames);
	}

	/**
	 * The Default Community is a community where all portal user belong to
	 * @return the default community URL
	 * @throws SystemException 
	 * @throws PortalException 
	 */
	public String getDefaultCommunityURL() {
		//get the portles to look for from the property file
		Properties props = new Properties();
		String comName = "";

		try {
			String propertyfile = this.getServletContext().getRealPath("")+"/config/resources.properties";			
			File propsFile = new File(propertyfile);
			FileInputStream fis = new FileInputStream(propsFile);
			props.load( fis);
			comName = props.getProperty("defaultcommunity");
		}
		//catch exception in case properties file does not exist
		catch(IOException e) {
			_log.error("/config/resources.properties not found, Returning \"Data e-Infrastructure gateway\" as default Community");
		}

		String toReturn = "";
		_log.trace("Default Community Read from config file: " + comName);
		Group myPlace = null;
		try {
			myPlace = GroupLocalServiceUtil.getGroup(OrganizationsUtil.getCompany().getCompanyId(), comName);

			if(myPlace.isCommunity()) {			 
				ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);
				toReturn = myPlace.getPathFriendlyURL(true, themeDisplay) + myPlace.getFriendlyURL();		     
			}
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		toReturn = getPortalBasicUrl()+toReturn;
		_log.trace("RETURNING Default Community URL: " + toReturn);
		return toReturn;
	}


	/**
	 * 
	 * @return the portal basic url, e.g. http://www.foo.com
	 */
	private String getPortalBasicUrl() {
		HttpServletRequest request = this.getThreadLocalRequest();
		String toReturn = "";
		//protocol
		String protocol = (request.isSecure()) ? "https://" : "http://" ;
		toReturn += protocol;
		//server name
		toReturn += request.getServerName();
		//port
		toReturn +=  (request.getServerPort() == 80) ? "" : ":"+request.getServerPort() ;

		request.getQueryString();

		_log.trace("\n getPortalBasicUrl: " +toReturn + "queryString: " +	request.getQueryString());
		return toReturn;
	}
}
