package org.gcube.portlets.user.gcubeloggedin.client.ui;

import org.gcube.portlets.user.gcubeloggedin.client.LoggedinServiceAsync;
import org.gcube.portlets.user.gcubeloggedin.shared.VObject;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;

public class AboutView extends Composite {

	private static AboutViewUiBinder uiBinder = GWT
			.create(AboutViewUiBinder.class);

	interface AboutViewUiBinder extends UiBinder<Widget, AboutView> {
	}

	public AboutView() {
		initWidget(uiBinder.createAndBindUi(this));
	}

	@UiField
	Button button;
	@UiField
	HTMLPanel htmlPanel;
	@UiField
	HTML description;
	
	private  LoggedinServiceAsync loggedinService;
	
	public AboutView(VObject vobj, LoggedinServiceAsync loggedinService) {
		initWidget(uiBinder.createAndBindUi(this));
		this.loggedinService = loggedinService;
		description.setHTML("<img class=\"imageVRE\" src=\"" +  vobj.getImageURL() + "\" />" + vobj.getDescription());
	}

	@UiHandler("button")
	void onClick(ClickEvent e) {
		loggedinService.getDefaultCommunityURL(new AsyncCallback<String>() {
			public void onFailure(Throwable arg0) {
				Window.alert("We're sorry we couldn't reach the server, try again later ... " + arg0.getMessage());
			}
			public void onSuccess(String url) {
				Window.open(url, "_self", "");									
			}						
		});
	}


}
