/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubeloggedin.client.ui;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.Hero;
import com.github.gwtbootstrap.client.ui.Image;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.gcubeloggedin.client.LoggedinServiceAsync;
import org.gcube.portlets.user.gcubeloggedin.client.ui.AboutView;
import org.gcube.portlets.user.gcubeloggedin.client.ui.EditDescriptionModal;
import org.gcube.portlets.user.gcubeloggedin.client.ui.LoadingText;
import org.gcube.portlets.user.gcubeloggedin.shared.VObject;

public class AboutView
extends Composite {
    private static int MAX_CHAR_DESC = 400;
    private static String SEE_LESS = "See less";
    private static String SEE_MORE = "See more";
    private static AboutViewUiBinder uiBinder = (AboutViewUiBinder)GWT.create(AboutViewUiBinder.class);
    private String vreDescription;
    @UiField
    Image vreImage;
    @UiField
    Heading vreName;
    @UiField
    HTML description;
    @UiField
    Button seeMore;
    @UiField
    Button editButton;
    @UiField
    Hero mainPanel;
    private EditDescriptionModal mod;
    boolean open = false;

    public AboutView() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public AboutView(VObject vobj, LoggedinServiceAsync loggedinService) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.vreDescription = vobj.getDescription();
        this.vreName.setText(vobj.getName());
        this.vreImage.setUrl(vobj.getImageURL());
        String desc = this.vreDescription = vobj.getDescription();
        if (desc.length() > MAX_CHAR_DESC) {
            desc = String.valueOf(desc.substring(0, MAX_CHAR_DESC)) + " ...";
            this.description.setHTML(desc);
            this.seeMore.setVisible(true);
            this.seeMore.setText(SEE_MORE);
        } else {
            this.description.setHTML(desc);
        }
        this.description.addStyleName("vre-description");
        if (vobj.isManager()) {
            this.editButton.setVisible(true);
        }
        this.mod = new EditDescriptionModal(vobj.getName(), vobj.getDescription());
    }

    @UiHandler(value={"seeMore"})
    void onSeemore(ClickEvent e) {
        GWT.log((String)this.seeMore.getText());
        if (!this.open) {
            this.description.setHTML(this.vreDescription);
            this.seeMore.setText(SEE_LESS);
            this.open = true;
        } else {
            this.description.setHTML(String.valueOf(this.vreDescription.substring(0, MAX_CHAR_DESC)) + " ...");
            this.seeMore.setText(SEE_MORE);
            this.open = false;
        }
    }

    @UiHandler(value={"editButton"})
    void onEditButton(ClickEvent e) {
        this.mod.show();
    }

    public static Widget getLoadingHTML() {
        return new LoadingText();
    }
}

