package org.gcube.portlets.user.gisviewerapp.client;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.google.gwt.event.dom.client.KeyCodes;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Dec 2, 2014
 *
 */
public class WmsDialog extends Dialog {

	private static final String WMS_DIALOG_HEADING = "Add WMS Layer";
	private TextField<String> displayName = new TextField<String>();
	private TextField<String> url = new TextField<String>();
	private WmsDialogHandler handler;
	private FormData formData;
	private FormPanel form;

	/**
	 *
	 */
	public WmsDialog(WmsDialogHandler handler) {
		super();
		this.handler = handler;
		this.setHeading(WMS_DIALOG_HEADING);
		this.setButtons(Dialog.OK);
		//dialog.setBodyStyleName("pad-text");
//		this.setAutoWidth(true);
		this.setModal(true);
		this.setWidth(400);
		this.setScrollMode(Scroll.AUTO); 
		this.setClosable(true);
		this.setHideOnButtonClick(true);  
		this.addListener(Events.Close, new Listener<BaseEvent>() {
			public void handleEvent(BaseEvent be) {
				hide();
			}
		});
		
		Button okButton = (Button)(this.getButtonBar().getItemByItemId("ok"));
		okButton.removeAllListeners();
		okButton.addSelectionListener(new SelectionListener<ButtonEvent>() {			
			@Override
			public void componentSelected(ButtonEvent ce) {
				submit();		
			}
		});

//		this.addListener(Events.clos, new Listener<BaseEvent>() {
//			public void handleEvent(BaseEvent be) {
//				hide();
//			}
//		});

		KeyListener keyListener = new KeyListener(){
			@Override
			public void componentKeyDown(ComponentEvent event) {
				super.componentKeyDown(event);
				if (event.getKeyCode() == KeyCodes.KEY_ENTER)
					submit();
			}
		};
		
		VerticalPanel vp = new VerticalPanel();
		
		// init title field
		displayName = new TextField<String>();
		displayName.setWidth(300);
		displayName.setAllowBlank(true);
		displayName.setFieldLabel("TITLE");
		displayName.setEmptyText("Enter layer display title (optional)...");
		displayName.addKeyListener(keyListener);
		
		// init title field
		url = new TextField<String>();
		url.setWidth(300);
		url.setAllowBlank(false);
		url.setFieldLabel("Layer WMS URL");
		url.setEmptyText("Enter layer WMS URL...");
		url.addKeyListener(keyListener);
		
		createForm();
	}

	/**
	 * 
	 */
	private void createForm() {
		formData = new FormData("-20");
		
		form = new FormPanel();
//		form.setHeading(WMS_DIALOG_HEADING);
		form.setFrame(true);
		form.setHeaderVisible(false);
		
		form.add(displayName, formData);
		form.add(url, formData);
		
		displayName.setAllowBlank(true);
		url.setAllowBlank(false);
		
		this.add(form);
	}

	private void submit() {
		String name = this.displayName.getValue();
		String url = this.url.getValue();
		if (url==null)
			MessageBox.alert("Error", "Insert a valid WMS URL", null);
		else {
			handler.addWmsLayer(name, url);
			this.hide();
		}			
	}
}