/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gisviewerapp.client;

import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.logging.Level;
import org.gcube.portlets.user.gisviewer.client.GisViewerPanel;
import org.gcube.portlets.user.gisviewerapp.client.ConstantGisViewerApp;
import org.gcube.portlets.user.gisviewerapp.shared.WmsParameters;

public class WmsRequestConverter {
    private GisViewerPanel gisViewer;
    private GisViewerPanel.LayerType layerType = GisViewerPanel.LayerType.FEATURETYPE;
    private String title;
    private String displayLayerName;
    private String url;
    private boolean isExternal = false;
    private boolean isBase = false;
    private boolean displayInLayerSwitcher = false;
    private ArrayList<String> styles;
    private boolean onTop = true;
    private ArrayList<String> listStyles;
    private String wmsRequest;

    public WmsRequestConverter(GisViewerPanel gisViewerPanel) {
        this.gisViewer = gisViewerPanel;
    }

    public void parseRequest(String wmsRequest, String displayName) throws Exception {
        this.wmsRequest = wmsRequest;
        int indexStart = wmsRequest.indexOf("?");
        if (indexStart >= 0) {
            this.url = wmsRequest.substring(0, indexStart);
            this.url = this.url.trim();
        } else {
            Window.alert((String)"Bad wms request '?' not found!");
        }
        String value = this.getValueOfParameter(WmsParameters.LAYERS, wmsRequest);
        if (value == null || value.isEmpty()) {
            Window.alert((String)"Bad wms request LAYER parameter not found!");
            throw new Exception("Layer name not found!");
        }
        this.displayLayerName = value;
        this.title = value;
        if (displayName != null && !displayName.isEmpty()) {
            this.displayLayerName = displayName;
        }
        this.listStyles = new ArrayList();
        String style = this.getValueOfParameter(WmsParameters.STYLES, wmsRequest);
        this.listStyles.add(style);
    }

    public void addRequestToGisViewer() {
        this.gisViewer.addLayerByWms(GisViewerPanel.LayerType.FEATURETYPE, this.displayLayerName, this.title, this.url, this.isExternal, this.isBase, this.displayInLayerSwitcher, this.listStyles, this.wmsRequest, this.onTop);
    }

    private String getValueOfParameter(WmsParameters wmsParam, String url) {
        ConstantGisViewerApp.logger.log(Level.INFO, "finding: " + wmsParam + " into " + url);
        String urlLower = url.toLowerCase();
        int index = urlLower.indexOf(wmsParam.getParameter().toLowerCase());
        String value = "";
        if (index > -1) {
            int start = index + wmsParam.getParameter().length() + 1;
            String sub = url.substring(start, url.length());
            int indexOfSeparator = sub.indexOf("&");
            int end = indexOfSeparator != -1 ? indexOfSeparator : sub.length();
            value = sub.substring(0, end);
        }
        ConstantGisViewerApp.logger.log(Level.INFO, "return value: " + value);
        return value;
    }

    public GisViewerPanel.LayerType getLayerType() {
        return this.layerType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLayerName() {
        return this.displayLayerName;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public boolean isDisplayInLayerSwitcher() {
        return this.displayInLayerSwitcher;
    }

    public ArrayList<String> getStyles() {
        return this.styles;
    }

    public boolean isOnTop() {
        return this.onTop;
    }

    public ArrayList<String> getListStyles() {
        return this.listStyles;
    }

    public void setLayerType(GisViewerPanel.LayerType layerType) {
        this.layerType = layerType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLayerName(String layerName) {
        this.displayLayerName = layerName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setBase(boolean isBase) {
        this.isBase = isBase;
    }

    public void setDisplayInLayerSwitcher(boolean displayInLayerSwitcher) {
        this.displayInLayerSwitcher = displayInLayerSwitcher;
    }

    public void setStyles(ArrayList<String> styles) {
        this.styles = styles;
    }

    public void setOnTop(boolean onTop) {
        this.onTop = onTop;
    }

    public void setListStyles(ArrayList<String> listStyles) {
        this.listStyles = listStyles;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WmsRequestConverter [gisViewer=");
        builder.append(this.gisViewer);
        builder.append(", layerType=");
        builder.append(this.layerType);
        builder.append(", title=");
        builder.append(this.title);
        builder.append(", layerName=");
        builder.append(this.displayLayerName);
        builder.append(", url=");
        builder.append(this.url);
        builder.append(", isExternal=");
        builder.append(this.isExternal);
        builder.append(", isBase=");
        builder.append(this.isBase);
        builder.append(", displayInLayerSwitcher=");
        builder.append(this.displayInLayerSwitcher);
        builder.append(", styles=");
        builder.append(this.styles);
        builder.append(", onTop=");
        builder.append(this.onTop);
        builder.append(", listStyles=");
        builder.append(this.listStyles);
        builder.append("]");
        return builder.toString();
    }
}

