/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gisviewerapp.client;

import com.google.gwt.user.client.Window;
import org.gcube.portlets.user.gisviewer.client.GisViewerPanel;
import org.gcube.portlets.user.gisviewer.client.commons.utils.WmsParameters;
import org.gcube.portlets.user.gisviewer.client.commons.utils.WmsUrlValidator;

public class WmsRequestConverter {
    private GisViewerPanel gisViewer;
    private GisViewerPanel.LayerType layerType = GisViewerPanel.LayerType.FEATURE_TYPE;
    private String title;
    private String displayLayerName;
    private String url;
    private boolean isExternal = false;
    private boolean isBase = false;
    private boolean displayInLayerSwitcher = false;
    private boolean onTop = true;
    private String wmsRequest;

    public WmsRequestConverter(GisViewerPanel gisViewerPanel) {
        this.gisViewer = gisViewerPanel;
    }

    public void addRequestToGisViewer(String wmsRequest, String displayName, String layerUUID) throws Exception {
        this.wmsRequest = wmsRequest;
        int indexStart = wmsRequest.indexOf("?");
        if (indexStart >= 0) {
            this.url = wmsRequest.substring(0, indexStart);
            this.url = this.url.trim();
        } else {
            Window.alert((String)"Bad wms request '?' not found!");
        }
        String layerName = WmsUrlValidator.getValueOfParameter((WmsParameters)WmsParameters.LAYERS, (String)wmsRequest);
        displayName = displayName == null || displayName.isEmpty() ? layerName : displayName;
        this.gisViewer.addLayerByWmsRequest(displayName, layerName, wmsRequest, this.isBase, this.displayInLayerSwitcher, layerUUID, this.onTop);
    }

    public String getWmsRequest() {
        return this.wmsRequest;
    }

    public GisViewerPanel.LayerType getLayerType() {
        return this.layerType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLayerName() {
        return this.displayLayerName;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public boolean isDisplayInLayerSwitcher() {
        return this.displayInLayerSwitcher;
    }

    public boolean isOnTop() {
        return this.onTop;
    }

    public void setLayerType(GisViewerPanel.LayerType layerType) {
        this.layerType = layerType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLayerName(String layerName) {
        this.displayLayerName = layerName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setBase(boolean isBase) {
        this.isBase = isBase;
    }

    public void setDisplayInLayerSwitcher(boolean displayInLayerSwitcher) {
        this.displayInLayerSwitcher = displayInLayerSwitcher;
    }

    public void setOnTop(boolean onTop) {
        this.onTop = onTop;
    }
}

