package org.gcube.portlets.user.gisviewer.client;

import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.MessageBox;

public class Constants {

	public static String VERSION = "2.1.3";
	public static String defaultGroup=
		// "5141",
		// "groupTemplate",
		// "group4cad6de9f-e980-4fda-a38b-41d1d0c6b3f0",
		// //very
		// big
		// csquare table
		// "group468e7b3b0-7e32-4718-89ab-d7cdcfe803d4",
		// "WMS_AbalisterStellarisJP2011_07_13_13_08_11_088",
		// "group4d2867cb8-d413-42b2-a271-a8d3d60d7e3e"
		// "group408849276-1b22-4427-9d1c-d2d8b3979e44",
		// "group428b5c4e7-4f5e-4ca1-bd6e-64f5287f35a2";
		// "group4026dc4de-7a57-4434-b9b4-495b15e7325c";
		// "vtigroup_64969591-09e0-40c3-b3c4-9f706572a470";
		
		//"group4838c40e5-410f-4848-b92b-6d52ded12489";
		"group45be7606f-4add-4636-ad14-f353163d0bd3";
		//"group4b02b381f-6572-4348-b827-0ecee9d7d8a0"
		//"vtigrp_4a60c06c-5e41-4818-87c4-5ff6be2ef610"
		;
		public static String defaultGroup2 = "groupTemplate";
	
	// LOG AND INFO PRINTING 
	public static boolean printLog=false;
	public static void log(String s) {
		if (printLog)
			System.out.println(s);
	}
	public static void info(String title, String text) {
		if (printLog)
			Info.display(title, text);
	}
	public static void alert(String string, String string2) {
		if (printLog)
			MessageBox.alert(string, string2, null);
	}

	// LAYERS
	public static final double defaultOpacityLayers = 0.7;
	
	public static final String[] brightLayers = {
		"TrueMarble.16km.2700x1350", 
		"Test.TrueMarble.16km.2700x1350_gf", 
		"depthmean",
		"depthmean_annual",
//		"depthMean",
	};
	
	public static final String[][] defaultStyleTransects = {
		{"depth_style", "DepthMean", "depth"},
		{"primprod_style", "PrimProdMean", "primprod"},
		{"salinity_style", "SalinityMean", "salinity"},
		{"sst_style", "SSTAnMean", "sst"},
		{"biodiversity_style", "Biodiv", "biodiversity"},
		{"ice_style", "IceConAnn", "ice"},
		{"occurrence_style", "GoodCell", "occurrence"}
	};
	
	public static final String[] dataStoresWithTransect = {
		"aquamapsdb",
		"aquamapsgeomar"
	};
	
	public static final String borderLayer = "Test.TrueMarble.16km.2700x1350_gf";
	public static final String baseLayer = "TrueMarble.16km.2700x1350";
	public static boolean isBorderLayerVisible=false;

	public static final int MAX_WFS_FEATURES = 200; // zero for no limit
	
	//INTERFACE
	public static final int geoWindowWidth=1000;//900;
	public static final int geoWindowHeight=760;//550;
	public static final int geoWindowMinWidth=300;
	public static final int geoWindowMinHeight=300;
	public static final String geoWindowTitle="GIS Viewer "+ VERSION;
	public static final boolean geoWindowShadow = false;
	public static final boolean geoWindowDataPanelOpenedAtStart = true;

	public static final String hcafLegendWidth = "400px";

	public static final int omHeight = 279; //379; 
	public static final int omWidth = 701;
	public static final int omMaxHeight = 550;
	public static final int omMaxWidth = 930;
	
	public static final String panelsBodyStyle = "background-color:#FFFFFF";
	public static final int mapPanelSpacingX = 5;
	public static final int mapPanelSpacingY = 56;
	public static final String MessageLoadingLayersData = "Loading layers data...";
	public static final String FAO_DATA_STORE = "FI Geoserver";
	public static final String FAO_DATA_STORE_PREFIX = "fifao_";

	public static final String defaultScope =
//			"/gcube/devsec/devVRE";
			"/d4science.research-infrastructures.eu/gCubeApps/EcologicalModelling";
	
	public static int openLayersMapDefaultZoom=2;
	public static boolean isOverViewMapVisible=false;
	
	public static boolean isSaveButtonEnabled = false;
	
	protected static int legendDialogMaxHeight = 500;
	protected static int legendDialogWidth = 200;

	public static enum Mode {NORMAL, TEST};
	public static Mode MODE = Mode.NORMAL;
	
	public static boolean getLayerTitles = true;
	public static boolean layersDragEnabled = true;
	//protected static String defaultProjection = "EPSG:900913";//"EPSG:4326";
	public static boolean buttonSaveLayerEnabled = true;
}
