package org.gcube.portlets.user.gisviewer.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.resources.Resources;

import com.extjs.gxt.ui.client.event.BoxComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.MessageBox.MessageBoxType;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Cookies;

public class GisViewer extends Window {
	
	GisViewerPanel gg;
	private boolean first = true;
	public static Resources resources = GWT.create(Resources.class);
	public static GisViewerServiceAsync service = (GisViewerServiceAsync) GWT.create(GisViewerService.class);

	
	public GisViewer() {
		this(new GisViewerParameters());
	}

	public GisViewer(GisViewerParameters parameters) {
		
		super();

		this.setHeading(Constants.geoWindowTitle);
		this.setSize(Constants.geoWindowWidth, Constants.geoWindowHeight);
		this.setMinWidth(Constants.geoWindowMinWidth);
		this.setMinHeight(Constants.geoWindowMinHeight);
		this.setMaximizable(true);
		this.setLayout(new FitLayout());
		
		if (Constants.geoWindowShadow)
			this.setStyleAttribute("padding", "10px");
		
		gg = new GisViewerPanel(parameters);
		this.add(gg);
		
		this.addListener(Events.Move, new Listener<BoxComponentEvent>(){
			@Override
			public void handleEvent(BoxComponentEvent be) {
				if (gg!=null) {
					gg.updateOpenLayersSize();
				}
			}
		});
	}
	

//	public void addLayers(LayerConfiguration ... layersConfigurations) {
//		gg.addLayersByLayerConfigurations(layersConfigurations);
//	}

	public void addLayersByNames(String ... layerNames) {
		gg.addLayersByLayerNames(Arrays.asList(layerNames));
	}

	public void addLayersByNames(List<String> layerNames) {
		gg.addLayersByLayerNames(layerNames);
	}

	public void addLayerByName(String layerName) {
		List<String> layerNames = new ArrayList<String>();
		layerNames.add(layerName);
		gg.addLayersByLayerNames(layerNames);
	}
	
	
	public void addLayersByLayerItems(List<LayerItem> layerItems) {
		gg.addLayersByLayerItems(layerItems);
	}

	public void addLayerByLayerItem(LayerItem layerItem) {
		gg.addLayerByLayerItem(layerItem);
	}
	
	public void addGroup(String groupName) {
		gg.addGroupByGroupName(groupName);
	}
	
	public void addLayersByLayerItemsToTop(List<LayerItem> layerItems) {
		gg.addLayersByLayerItemsToTop(layerItems);
	}

	public void addLayerByLayerItemToTop(LayerItem layerItem) {
		gg.addLayerByLayerItemToTop(layerItem);
	}

	public void removeAllLayers() {
		gg.removeAllLayers();
	}
	
	public void addLayerByWms(String title, String layerName, String url, boolean isBase, boolean displayInLayerSwitcher) {
		gg.addLayerByWms(title, layerName, url, isBase, displayInLayerSwitcher);
	}
	
	/* (non-Javadoc)
	 * @see com.extjs.gxt.ui.client.widget.Window#show()
	 */
	@Override
	public void show() {
		super.show();
		showIntro();
	}

	/**
	 * 
	 */
	private void showIntro() {
		if (first) {
			final String str = "first_time";
			if (Cookies.getCookie(str) == null) {
				MessageBox box = new MessageBox();
				box.setType(MessageBoxType.CONFIRM);
				box.setButtons(MessageBox.OKCANCEL);
				box.setIcon(MessageBox.INFO);
				box.setClosable(false);
				box.setMaxWidth(400);
				box.setMinWidth(400);
				box.setMessage("" +
						"GIS Viewer is a standalone application for supporting geospatial data visualization and management including:" +
						"<br><br> - layers visualization where the layers reside in multiple data sources, namely geoserver instances;" +
						"<br> - layers ordering with respect to the z axis through drag and drop;" +
						"<br> - layers filtering through cql;" +
						"<br> - layers data visualization;" +
						"<br><br>GIS Viewer has been designed and developed by the NeMIS Laboratory team at ISTI-CNR Pisa, Italy." +
						"<br><br>The Gis Viewer has been produced with the co-funding of the European Commission in the context of the iMarine project. " +
						"iMarine (www.i-marine.eu) (RI – 283644) is a Research Infrastructures Combination of Collaborative Project and Coordination " +
						"and Support Action (CP-CSA) co-funded by the European Commission under the Capacities Programme, Framework Programme Seven (FP7)." +
						"<br><br>Press CANCEL if you want this message not to be shown anymore.");
						
//						"Gis Viewer is a standalone application developed by the NeMIS Laboratory at ISTI-CNR Pisa, Italy.\n" +
//						"The software was developed during the iMarine european project, which promotes an initiative to establish and operate " +
//						"an e-infrastructure supporting the principles of the Ecosystem Approach to fisheries management " +
//						"and conservation of marine living resources.\npress CANCEL if you want this message not to be shown anymore.");
				box.setModal(true);
				box.setTitle("Welcome to the GisViewer");
				box.addCallback(new Listener<MessageBoxEvent>(){
					@Override
					public void handleEvent(MessageBoxEvent be) {
						if (be.getButtonClicked().getText().equals("Cancel"))
							Cookies.setCookie(str, str);
					}
				});
				box.show();			
			}
			first = false;
		}
	}
	
	public String getVersion() {
		return Constants.VERSION;
	}
}
