package org.gcube.portlets.user.gisviewer.client.openlayers;


import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.resources.Images;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.IconAlign;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.menu.SeparatorMenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Label;


public class ToolBarPanel extends ToolBar {

	private OpenLayersMap om;
	
	private HorizontalPanel transectPanel = new HorizontalPanel();
	private Label labelTransect = new Label("Draw a line for a transect on the layer ");

	private ToolbarHandler toolBarHandler;
	private LayerItem layerItemTransect;

	private Button maxExtentButton = new Button();
	private ToggleButton panToggle = new ToggleButton();
	private ToggleButton zoomInToggle = new ToggleButton();
	private Button zoomOutButton = new Button();
	private ToggleButton clickDataToggle = new ToggleButton();
	private ToggleButton boxDataToggle = new ToggleButton();
	private Button removeDataButton = new Button();
	private Button exportButton;
	private Button saveMapImageButton;

	private final static String TOGGLE_GROUP = "toggleGroup";

	private static final String BOX_DATA_TOOLTIP = "Data box selection";
	private static final String CLICK_DATA_TOOLTIP = "Data point selection";
	private static final String PAN_TOOLTIP = "Pan";
	private static final String ZOOM_IN_TOOLTIP = "Zoom in";
	private static final String ZOOM_OUT_TOOLTIP = "Zoom out";
	private static final String MAX_EXTENT_TOOLTIP = "Zoom to max extent";
	private static final String CANCEL_DATA_TOOLTIP = "Cancel spatial query selection";
	private static final String EXPORT_TOOLTIP = "Export a map snapshot";
	private static final String SAVE_TOOLTIP = "Save a map snapshot into the Workspace";

	private enum TOGGLES {PAN, ZOOMIN, CLICKDATA, BOXDATA};

	private static final String[][] FORMATS = {
		{"GIF", "image/gif"},
		{"JPEG", "image/jpeg"},
		{"PNG", "image/png"},
	};
	private static final AbstractImagePrototype[] FORMAT_IMAGES = {
		Images.iconGif(),
		Images.iconJpeg(),
		Images.iconPng(),
	};



	public ToolBarPanel(ToolbarHandler toolbarHandler, OpenLayersMap om) {
		super();		
		this.om = om;
		this.toolBarHandler = toolbarHandler;

		setMaxExtentButton();
		setPanToggle();
		setZoomInToggle();
//		setZoomOutButton();
		setClickDataToggle();
		setBoxDataToggle();
		setRemoveDataButton();
		
		setOpenBrowserMapImageBox();

		this.getAriaSupport().setLabel("Openlayers Toolbar");
//		Html view = new Html("View");
//		view.setStyleAttribute("margin-right", "15px");
//		view.setStyleAttribute("margin-left", "10px");
//		view.setStyleAttribute("color", "#15428B");
//		this.add(view);
		
		this.add(maxExtentButton);
		this.add(panToggle);
		this.add(zoomInToggle);
//		this.add(zoomOutButton);
		
		this.add(new SeparatorToolItem());
//		Html query = new Html("Query");
//		query.setStyleAttribute("margin-right", "15px");
//		query.setStyleAttribute("margin-left", "10px");
//		query.setStyleAttribute("color", "#15428B");
//		
//		this.add(query);
		this.add(clickDataToggle);
		this.add(boxDataToggle);
		this.add(removeDataButton);	
		
		this.add(new SeparatorToolItem());
//		this.add(new SeparatorMenuItem());

		addProjectionBox();
		addTransectBox();
		this.add(exportButton);

		if (toolbarHandler.isSaveSupported()) {
			setSaveMapImageBox();
			this.add(saveMapImageButton);
		}
	}



	/**
	 * 
	 */
	private void setOpenBrowserMapImageBox() {
		// layer export	    
		exportButton = new Button("", Images.iconExport24());
		exportButton.setScale(ButtonScale.MEDIUM);
		exportButton.setToolTip(EXPORT_TOOLTIP);
		exportButton.setText("Export");
		exportButton.setIconAlign(IconAlign.LEFT);
		Menu menuExport = new Menu();
		menuExport.setStyleName("gisViewerMenu");
		int i=0;
		for (final String[] saveItem : FORMATS) {			
			menuExport.add(new MenuItem(saveItem[0], FORMAT_IMAGES[i++], new SelectionListener<MenuEvent>(){
				@Override
				public void componentSelected(MenuEvent ce) {
					toolBarHandler.openBrowserMapImage(saveItem[1], true);
				}
			}));
		}
		exportButton.setMenu(menuExport);
//		exportButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
	}



	/**
	 * 
	 */
	private void setSaveMapImageBox() {
		// layer export	    
		saveMapImageButton = new Button("", Images.iconSave());
		saveMapImageButton.setToolTip(SAVE_TOOLTIP);
		Menu menuExport = new Menu();
		menuExport.setStyleName("gisViewerMenu");
		int i=0;
		for (final String[] saveItem : FORMATS) {			
			menuExport.add(new MenuItem(saveItem[0], FORMAT_IMAGES[i++], new SelectionListener<MenuEvent>(){
				@Override
				public void componentSelected(MenuEvent ce) {
					toolBarHandler.saveMapImage(saveItem[1], true);
				}
			}));
		}
		saveMapImageButton.setMenu(menuExport);	    
	}



	/**
	 * 
	 */
	private void addTransectBox() {
		labelTransect.setStyleName("vertical_middle");
		
		transectPanel.setBorders(true);
		transectPanel.add(labelTransect);
		
		transectPanel.setStyleName("geo-panel-body");
		add(new Html("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"));
		
		transectPanel.setVisible(false);
		
		add(transectPanel);
	}



	/**
	 * @param button
	 * @param boxDataTooltip 
	 * @param abstractImagePrototype 
	 */
	private void setUpBotton(Button button, AbstractImagePrototype img, String toolTip) {		
		button.setIcon(img);
//		button.addStyleName("iconOpenlayersToolbar");
		button.setToolTip(toolTip);
		button.setScale(ButtonScale.MEDIUM);
		button.setIconAlign(IconAlign.LEFT);
//		button.setSize(25, 25);
	}


	private void setBoxDataToggle() {
		setUpBotton(boxDataToggle, Images.iconBoxData24(), BOX_DATA_TOOLTIP);
		boxDataToggle.setText("Data box");
		boxDataToggle.setToggleGroup(TOGGLE_GROUP);
		boxDataToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.BOXDATA);
				moveToMinimunZoomSQ();
			}
		});
	}

	private void setZoomInToggle() {
		zoomInToggle = new ToggleButton();
		zoomInToggle.setText("Zoom in");
		zoomInToggle.setIconAlign(IconAlign.LEFT);
		zoomInToggle.setIcon(Images.iconZoomIn24());
		zoomInToggle.setScale(ButtonScale.MEDIUM);
		zoomInToggle.setToolTip(ZOOM_IN_TOOLTIP);
		//zoomInToggle.setToggleGroup(TOGGLE_GROUP);
		zoomInToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.ZOOMIN);
			}
		});
	}

	private void setClickDataToggle() {
		setUpBotton(clickDataToggle, Images.iconClickData24(), CLICK_DATA_TOOLTIP);
		clickDataToggle.setText("Data point");
		clickDataToggle.setToggleGroup(TOGGLE_GROUP);
		clickDataToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.CLICKDATA);
				moveToMinimunZoomSQ();
			}
		});
	}

	private void setPanToggle() {
		setUpBotton(panToggle, Images.iconPan24(), PAN_TOOLTIP);
		panToggle.setText("Pan");
		panToggle.toggle(true);
		panToggle.setToggleGroup(TOGGLE_GROUP);
		panToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.PAN);
			}
		});
	}

	private void setZoomOutButton() {
		setUpBotton(zoomOutButton, Images.iconZoomOut24(), ZOOM_OUT_TOOLTIP);
		zoomOutButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				om.zoomOut();				
			}
		});
	}

	private void setMaxExtentButton() {
		setUpBotton(maxExtentButton, Images.iconMaxExtent24(), MAX_EXTENT_TOOLTIP);
		maxExtentButton.setText("Max Extent");
		maxExtentButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				
				if(om.getDataFeature()!=null){
					
					MessageBox.confirm("Confirm?", "Remove spatial query?", null).addCallback(new Listener<MessageBoxEvent>() {
						
						@Override
						public void handleEvent(MessageBoxEvent be) {
							
							String clickedButton = be.getButtonClicked().getItemId();
							if(clickedButton.equals(Dialog.YES)){
								om.removeDataFeature();
								om.zoomToMaxExtent();
								togglePressed(false, TOGGLES.BOXDATA);
								togglePressed(false, TOGGLES.CLICKDATA);
							}if(clickedButton.equals(Dialog.NO)){
								moveToMinimunZoomSQ();
							}
							
						}
					});
				}
			}
		});
	}

	/**
	 * 
	 */
	private void setRemoveDataButton() {
		setUpBotton(removeDataButton, Images.iconToolbarRemove24(), CANCEL_DATA_TOOLTIP);
		removeDataButton.setText("Cancel");
		removeDataButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				om.removeDataFeature();
			}
		});
	}

	private void togglePressed(boolean isPressed, TOGGLES toggleType) {
		if (!isPressed) {
			panToggle.toggle(true);
			if (toggleType!=TOGGLES.PAN)
				togglePressed(true, TOGGLES.PAN);
		} else {
			om.activateClickData(toggleType==TOGGLES.CLICKDATA);
			om.activateDrawBoxControl(toggleType==TOGGLES.BOXDATA);
			om.activateZoomIn(toggleType==TOGGLES.ZOOMIN);
			om.activatePan(toggleType==TOGGLES.PAN);
			toolBarHandler.deactivateTransect(layerItemTransect);
		}
	}

	/**
	 * @param layerItem
	 * @param b
	 */
	public void setTransectPanelVisible(LayerItem layerItem, boolean visible) {
		if (visible)
			this.labelTransect.setText("Draw a transect line for the layer "+layerItem.getName());
		else
			om.activateTransectDraw(false);
		this.transectPanel.setVisible(visible);
		this.layerItemTransect = layerItem;
	}


	/**
	 * 
	 */
	public void setAllUp() {
		om.activateClickData(false);
		om.activateDrawBoxControl(false);
		om.activateZoomIn(false);
		om.activatePan(false);
	}
	
	private void addProjectionBox(){
		// TODO
	}
	
	/**
	 * Added by Francesco M.
	 * @return
	 */
	public boolean isPointDataTogglePressed(){
		return clickDataToggle.isPressed();
	}
	
	/**
	 * Added by Francesco M.
	 * @return
	 */
	public boolean isBoxDataTogglePressed(){
		return boxDataToggle.isPressed();
	}
	
	
	/*
	private void moveToZoom(int zoom){
		
		int zoomLevel = om.getMap().getZoom();
		
		if(zoomLevel<zoom)
			om.getMap().zoomTo(zoom);
	}
	*/
	
	/**
	 * 
	 * Move To Minimun Zoom Level To Spatila Query
	 * 
	 * by Francesco M. - patching Openlayers.2.13.1
	 */
	private void moveToMinimunZoomSQ(){
		
		int zoomLevel = om.getMap().getZoom();
		int minimunZoom = Constants.defaultOpenLayersMapDefaultZoom+1;
		if(zoomLevel<minimunZoom){
			Info.display("Zooming...", "Zoom to level "+minimunZoom +" to show spatial feauture");
			om.getMap().zoomTo(minimunZoom);
		}
	}

}