/**
 * 
 */
package org.gcube.portlets.user.gisviewer.server;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.gcube.portlets.user.gisviewer.client.commons.beans.GisViewerBaseLayerInterface;
import org.gcube.portlets.user.gisviewer.server.baselayer.BaseLayerPropertyReader;


/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class DefaultGisViewerServiceImpl extends GisViewerServiceImpl {

	private static final long serialVersionUID = 7965911406156513171L;

	//DEVELOPMENT ENVIRONMENT
	public static String geoServerUrl="http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver";
	public static String geoNetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu:8080/geonetwork";

	private static Logger logger = Logger.getLogger(DefaultGisViewerServiceImpl.class);
	//PRODUCTION ENVIRONMENT
	
//	public static String geoServerUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver";
//	public static String geoNetworkUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork";
	
//	public static String geoServerWMSUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/wms";
//	public static String geoServerGWCUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/gwc/service/wms";
//	public static String urlGroup = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/rest/layergroups.xml";
	/*
http://monitor.d4science.research-infrastructures.eu/chartview/?
x1=-58.88671875
&y1=30.5859375
&x2=-24.78515625
&y2=13.359375
&SRID=4326
&maxelements=1000
&minimumgap=-1
&tablename=lcod20120404193526226
&biodiversityfield=maxspeciescountinacell

http://monitor.d4science.research-infrastructures.eu/chartview/?
x1=-136.23046875
&y1=6.328125
&x2=-118.30078125
&y2=-13.359375
&SRID=4326
&maxelements=1000
&minimumgap=-1
&tablename=depth
&biodiversityfield=DepthMean
	*/
	private static final String geoNetworkUser = "admin";
	private static final String geoNetworkPwd = "admin";
	private static final String geoServerUser = "admin";
	private static final String geoServerPwd = "gcube@geo2010";
	private static final String transectUrl = "http://monitor.d4science.research-infrastructures.eu/chartview/"; //ex: "http://portal.d4science.research-infrastructures.eu/chartview/";
	private static final String scope = "/gcube/devsec";
	
	protected GisViewerServiceParameters parameters;


	@Override
	protected GisViewerServiceParameters getParameters() {
		if (parameters == null) parameters = new GisViewerServiceParameters(geoServerUrl, geoServerUser, geoServerPwd, geoNetworkUrl, geoNetworkUser, geoNetworkPwd, transectUrl, scope);
		return parameters;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.server.GisViewerServiceImpl#getBaseLayersToAddGisViewer()
	 */
	@Override
	protected List<? extends GisViewerBaseLayerInterface> getBaseLayersToAddGisViewer() throws Exception {
		
		BaseLayerPropertyReader bl = null;
		try{
			logger.info("Instancing BaseLayerPropertyReader");
			bl = new BaseLayerPropertyReader();
			logger.info("Read base layer: "+bl);
		}catch(Exception e){
			logger.error("Error on reading BaseLayerPropertyReader! Returning hardcode wms base layer");
			bl = null;
		}
		
		final String layerName = (bl!=null && bl.getLayerName()!=null)?bl.getLayerName():"aquamaps:TrueMarble.16km.2700x1350";
		final String layerTitle = (bl!=null && bl.getLayerTitle()!=null)?bl.getLayerTitle():"True Marble";
		final String layerWmsUrl = (bl!=null && bl.getLayerWmsUrl()!=null)?bl.getLayerWmsUrl():"http://geoserver1.d4science.org/geoserver/aquamaps/wms";
		
		GisViewerBaseLayerInterface trueMarble = new GisViewerBaseLayerInterface() {
			
			@Override
			public boolean isDisplay() {
				return true;
			}
			
			@Override
			public String getWmsURL() {
				return layerWmsUrl;
			}
			
			@Override
			public String getTitle() {
				return layerTitle;
			}
			
			@Override
			public String getName() {
				// TODO Auto-generated method stub
				return layerName;
			}
		};
		
		List<GisViewerBaseLayerInterface> baseLayer = new ArrayList<GisViewerBaseLayerInterface>(1);
		baseLayer.add(trueMarble);
		
		return baseLayer;
	}

}
