package org.gcube.portlets.user.homelibrary.jcr.home;

import java.io.File;
import java.util.List;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.data.DataArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.data.JCRDataArea;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;



public class JCRHome implements Home {

	private final HomeManager homeManager;
	private final JCRUser owner;

	private final File persistenceFolder;
	private final JCRRepository repository;
	private final Workspace workspace;
	
	private static Logger logger = Logger.getLogger(JCRHome.class.getName());
	
	public JCRHome(HomeManager homeManager, JCRUser user, File persistenceFolder) throws Exception {
		super();
		
		
		this.owner = user;
		this.persistenceFolder = persistenceFolder;
		this.homeManager = homeManager;
		this.repository = new JCRRepository(user);
		this.workspace = new JCRWorkspace(this, repository);	
	}
	

	
	@Override
	public HomeManager getHomeManager() {
		return homeManager;
	}
	

	@Override
	public User getOwner() {
		return owner;
	}

	@Override
	public Workspace getWorkspace() throws WorkspaceFolderNotFoundException,
			InternalErrorException {
		return workspace;
	}

	@Override
	public DataArea getDataArea() throws InternalErrorException {
		//TODO
		return  new JCRDataArea(null);
	}

	@Override
	public List<String> listScopes() throws  InternalErrorException {
		
		try {
			return repository.listScopes();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		}
	}

}
