/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.home;

import java.io.File;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.data.DataArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.data.JCRDataArea;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRHome
implements Home {
    private final HomeManager homeManager;
    private final JCRUser owner;
    private final File persistenceFolder;
    private final JCRRepository repository;
    private final Workspace workspace;
    private static Logger logger = Logger.getLogger((String)JCRHome.class.getName());

    public JCRHome(HomeManager homeManager, JCRUser user, File persistenceFolder) throws Exception {
        this.owner = user;
        this.persistenceFolder = persistenceFolder;
        this.homeManager = homeManager;
        this.repository = new JCRRepository(user);
        this.workspace = new JCRWorkspace(this, this.repository);
    }

    public HomeManager getHomeManager() {
        return this.homeManager;
    }

    public User getOwner() {
        return this.owner;
    }

    public Workspace getWorkspace() throws WorkspaceFolderNotFoundException, InternalErrorException {
        return this.workspace;
    }

    public DataArea getDataArea() throws InternalErrorException {
        return new JCRDataArea(null);
    }

    public List<String> listScopes() throws InternalErrorException {
        try {
            return this.repository.listScopes();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

