/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Image;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.DocumentMetadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeriesInfo;

public class HomeLibraryImporter {
    public static int errors = 0;
    public static int notImported = 0;

    public static void copyItem(Workspace newWorkspace, WorkspaceItem oldRoot, String newRoot) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException, WrongItemTypeException {
        if (oldRoot.getChildren() == null) {
            return;
        }
        for (WorkspaceItem childItem : oldRoot.getChildren()) {
            WorkspaceItem item = HomeLibraryImporter.createJCRWorkspaceItem(newWorkspace, newRoot, childItem);
            if (item == null) continue;
            HomeLibraryImporter.copyItem(newWorkspace, childItem, item.getId());
        }
    }

    public static WorkspaceItem createJCRWorkspaceItem(Workspace newWorkspace, String destinationFolderId, WorkspaceItem oldItem) throws InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException, InternalErrorException, WrongItemTypeException {
        switch (oldItem.getType()) {
            case FOLDER: {
                try {
                    return newWorkspace.createFolder(oldItem.getName(), oldItem.getDescription(), destinationFolderId);
                }
                catch (ItemAlreadyExistException e) {
                    System.err.println("Item " + oldItem.getName() + " already exists");
                    return newWorkspace.find(oldItem.getName(), destinationFolderId);
                }
            }
            case FOLDER_ITEM: {
                return HomeLibraryImporter.createJCRWorkspaceFolderItem(newWorkspace, destinationFolderId, (FolderItem)oldItem);
            }
        }
        return null;
    }

    public static WorkspaceItem createJCRWorkspaceFolderItem(Workspace newWorkspace, String destinationFolderId, FolderItem oldItem) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException {
        try {
            switch (oldItem.getFolderItemType()) {
                case EXTERNAL_FILE: {
                    ExternalFile file = (ExternalFile)oldItem;
                    return newWorkspace.createExternalFile(file.getName(), file.getDescription(), file.getMimeType(), file.getData(), destinationFolderId);
                }
                case EXTERNAL_IMAGE: {
                    ExternalImage image = (ExternalImage)oldItem;
                    return newWorkspace.createExternalImage(image.getName(), image.getDescription(), image.getMimeType(), image.getData(), destinationFolderId);
                }
                case EXTERNAL_PDF_FILE: {
                    ExternalPDFFile pdfFile = (ExternalPDFFile)oldItem;
                    return newWorkspace.createExternalPDFFile(pdfFile.getName(), pdfFile.getDescription(), pdfFile.getMimeType(), pdfFile.getData(), destinationFolderId);
                }
                case EXTERNAL_URL: {
                    ExternalUrl url = (ExternalUrl)oldItem;
                    return newWorkspace.createExternalUrl(url.getName(), url.getDescription(), url.getUrl(), destinationFolderId);
                }
                case AQUAMAPS_ITEM: {
                    AquaMapsItem aquaMapsItem = (AquaMapsItem)oldItem;
                    List images = aquaMapsItem.getImages();
                    HashMap<String, InputStream> map = new HashMap<String, InputStream>();
                    for (Image img : images) {
                        map.put(img.getName(), img.getData());
                    }
                    return newWorkspace.createAquaMapsItem(aquaMapsItem.getName(), aquaMapsItem.getDescription(), aquaMapsItem.getMapName(), aquaMapsItem.getMapType(), aquaMapsItem.getAuthor(), aquaMapsItem.getNumberOfSpecies(), aquaMapsItem.getBoundingBox(), aquaMapsItem.getPsoThreshold(), aquaMapsItem.getNumberOfGeneratedImages(), aquaMapsItem.getMetadata().getData(), map, destinationFolderId);
                }
                case TIME_SERIES: {
                    TimeSeries ts = (TimeSeries)oldItem;
                    TimeSeriesInfo infos = ts.getTimeSeriesInfo();
                    return newWorkspace.createTimeSeries(ts.getName(), ts.getDescription(), infos.getId(), infos.getTitle(), infos.getCreator(), infos.getDescription(), infos.getCreationDate(), infos.getPublisher(), infos.getSourceId(), infos.getSourceName(), infos.getRights(), infos.getDimension(), ts.getHeaderLabels(), ts.getCompressedData(), destinationFolderId);
                }
                case QUERY: {
                    Query query = (Query)oldItem;
                    return newWorkspace.createQuery(query.getName(), query.getDescription(), query.getQuery(), query.getQueryType(), destinationFolderId);
                }
                case REPORT: {
                    Report report = (Report)oldItem;
                    return newWorkspace.createReport(report.getName(), report.getDescription(), report.getCreated(), report.getLastEdit(), report.getAuthor(), report.getLastEditBy(), report.getTemplateName(), report.getNumberOfSections(), report.getStatus(), report.getData(), destinationFolderId);
                }
                case REPORT_TEMPLATE: {
                    ReportTemplate reportTemplate = (ReportTemplate)oldItem;
                    return newWorkspace.createReportTemplate(reportTemplate.getName(), reportTemplate.getDescription(), reportTemplate.getCreated(), reportTemplate.getLastEdit(), reportTemplate.getAuthor(), reportTemplate.getLastEditBy(), reportTemplate.getNumberOfSections(), reportTemplate.getStatus(), reportTemplate.getData(), destinationFolderId);
                }
                case WORKFLOW_REPORT: {
                    WorkflowReport workflowReport = (WorkflowReport)oldItem;
                    return newWorkspace.createWorkflowReport(workflowReport.getName(), workflowReport.getDescription(), workflowReport.getWorkflowId(), workflowReport.getWorkflowStatus(), workflowReport.getWorkflowData(), destinationFolderId);
                }
                case WORKFLOW_TEMPLATE: {
                    WorkflowTemplate w = (WorkflowTemplate)oldItem;
                    return newWorkspace.createWorkflowTemplate(w.getName(), w.getDescription(), w.getWorkflowId(), w.getWorkflowStatus(), w.getWorkflowData(), destinationFolderId);
                }
                case DOCUMENT: {
                    Document document = (Document)oldItem;
                    if (document.getData() == null) {
                        System.err.println("DATA is null");
                        return null;
                    }
                    HashMap mapMetadata = new HashMap();
                    for (Map.Entry entry : document.getMetadata().entrySet()) {
                        mapMetadata.put(entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                    return newWorkspace.createDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                }
                case IMAGE_DOCUMENT: {
                    ImageDocument document = (ImageDocument)oldItem;
                    HashMap mapMetadata = new HashMap();
                    for (Map.Entry entry : document.getMetadata().entrySet()) {
                        mapMetadata.put(entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                    return newWorkspace.createImageDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                }
                case PDF_DOCUMENT: {
                    PDFDocument document = (PDFDocument)oldItem;
                    HashMap mapMetadata = new HashMap();
                    for (Map.Entry entry : document.getMetadata().entrySet()) {
                        mapMetadata.put(entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                    return newWorkspace.createPDFDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                }
                case URL_DOCUMENT: {
                    UrlDocument document = (UrlDocument)oldItem;
                    HashMap mapMetadata = new HashMap();
                    for (Map.Entry entry : document.getMetadata().entrySet()) {
                        mapMetadata.put(entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                    return newWorkspace.createUrlDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                }
                case METADATA: {
                    Metadata metadata = (Metadata)oldItem;
                    return newWorkspace.createMetadata(metadata.getName(), metadata.getDescription(), metadata.getURI(), metadata.getSchema(), metadata.getLanguage(), metadata.getData(), metadata.getCollectionName(), destinationFolderId);
                }
            }
            System.err.println("ITEM is not been imported " + oldItem.getFolderItemType());
            ++notImported;
            return null;
        }
        catch (ItemAlreadyExistException e) {
            System.err.println("Item " + oldItem.getName() + " already exists");
            return null;
        }
    }
}

