package org.gcube.portlets.user.homelibrary.jcr.data.application;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.gcube.portlets.user.homelibrary.home.data.application.ApplicationData;
import org.gcube.portlets.user.homelibrary.home.data.application.ApplicationDataType;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;

import com.thoughtworks.xstream.XStream;

public abstract class AbstractApplicationData implements ApplicationData {
	
	private String name;
	private ApplicationDataType type;
	
	private String applicationName;
	private transient JCRRepository contentManager;
	private transient XStream xstream;

	/**
	 * Create a new AbstractApplicationData.
	 * @param name the application data name.
	 * @param type the application data type.
	 */
	public AbstractApplicationData(String applicationName,String name,
			ApplicationDataType type, JCRRepository contentManager) {
		
		this.applicationName = applicationName;
		this.name = name;
		this.type = type;
		this.contentManager = contentManager;
		this.xstream = new XStream(); 
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof AbstractApplicationData))
			return false;
		AbstractApplicationData other = (AbstractApplicationData) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public ApplicationDataType getType() {
		return type;
	}
	
	@Override
	public void dataUpdated() throws RuntimeException {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		xstream.toXML(this, out);
		InputStream in = new ByteArrayInputStream(out.toByteArray());
		
		//TODO save in contentManager
		
	}

}
