package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRReportTemplate extends JCRWorkspaceFolderItem implements
		ReportTemplate {
	
	private static final String CREATED  			= "hl:created";
	private static final String LAST_EDIT 			= "hl:lastEdit";
	private static final String AUTHOR 				= "hl:author";
	private static final String LAST_EDIT_BY 		= "hl:lastEditBy";
	private static final String NUMBER_OF_SECTION 	= "hl:numberOfSection";
	private static final String STATUS				= "hl:status";
	
	private static final String NT_CONTENT			= "nthl:reportTemplateContent";
	
	private final Calendar created;
	private final Calendar lastEdit;
	private final String author;
	private final String lastEditBy;
	private final int numberOfSections;
	private final String status;

	private final JCRFile file;
	
	public JCRReportTemplate(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
		super(workspace, node);
		
		Node nodeContent = node.getNode(CONTENT);
		this.created = nodeContent.getProperty(CREATED).getDate();
		this.lastEdit = nodeContent.getProperty(LAST_EDIT).getDate();
		this.author = nodeContent.getProperty(AUTHOR).getString();
		this.lastEditBy = nodeContent.getProperty(LAST_EDIT_BY).getString();
		this.numberOfSections = (int)nodeContent.getProperty(NUMBER_OF_SECTION).getLong();
		this.status = nodeContent.getProperty(STATUS).getString();
		this.file = new JCRFile(nodeContent);
	}
	
	public JCRReportTemplate(JCRWorkspace workspace,Node node, String name,
			String description, Calendar created, Calendar lastEdit,
			String author, String lastEditBy, int numberOfSections, String status,
			InputStream templateData) throws RepositoryException  {
		super(workspace,node,name,description);
		
		Validate.notNull(created, "Created must be not null");
		Validate.notNull(lastEdit, "LastEdit must be not null");
		Validate.notNull(author, "Author must be not null");
		Validate.notNull(lastEditBy, "LastEditBy must be not null");
		Validate.notNull(status, "Status must be not null");
		Validate.notNull(templateData, "TemplateData must be not null");
		
		this.created = created;
		this.lastEdit = lastEdit;
		this.author = author;
		this.lastEditBy = lastEditBy;
		this.numberOfSections = numberOfSections;
		this.status = status;
		
		node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.REPORT_TEMPLATE.toString());
		
		Node contentNode = node.addNode(CONTENT,NT_CONTENT);
		this.file = new JCRFile(contentNode, new BufferedInputStream(templateData));
		contentNode.setProperty(AUTHOR,author);
		contentNode.setProperty(CREATED, created);
		contentNode.setProperty(LAST_EDIT, lastEdit);
		contentNode.setProperty(LAST_EDIT_BY, lastEditBy);
		contentNode.setProperty(NUMBER_OF_SECTION, numberOfSections);
		contentNode.setProperty(STATUS, status);
	}

	@Override
	public long getLength() throws InternalErrorException {
		return file.getLength();
	}

	@Override
	public InputStream getData() throws InternalErrorException {
		return file.getData();
	}

	@Override
	public Calendar getCreated() {
		return created;
	}

	@Override
	public Calendar getLastEdit() {
		return lastEdit;
	}

	@Override
	public String getAuthor() {
		return author;
	}

	@Override
	public String getLastEditBy() {
		return lastEditBy;
	}

	@Override
	public int getNumberOfSections() {
		return numberOfSections;
	}

	@Override
	public String getStatus() {
		return status;
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.REPORT_TEMPLATE;
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		file.save(node);
		
	}

}
