/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.portlets.user.homelibrary.util.Util;

public class JCRExternalUrl
extends JCRWorkspaceFolderItem
implements ExternalUrl {
    private static final String NT_FILE = "nt:resource";
    protected final JCRFile content;

    public JCRExternalUrl(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        this.content = new JCRFile(node.getNode("jcr:content"));
    }

    public JCRExternalUrl(JCRWorkspace workspace, Node node, String name, String description, String url) throws RepositoryException {
        super(workspace, node, name, description);
        Validate.notNull((Object)url, (String)"url must be not null");
        this.content = new JCRFile(node.addNode("jcr:content", NT_FILE), new ByteArrayInputStream(url.getBytes()));
        node.setProperty("hl:workspaceItemType", FolderItemType.EXTERNAL_URL.toString());
    }

    @Override
    public long getLength() throws InternalErrorException {
        try {
            return Util.readStreamAsString((InputStream)this.content.getData()).length();
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getUrl() throws InternalErrorException {
        try {
            return Util.readStreamAsString((InputStream)this.content.getData());
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_URL;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        this.content.save(node);
    }
}

