/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.Calendar;
import java.util.Properties;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.portlets.user.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;

public abstract class JCRWorkspaceItem
implements WorkspaceItem {
    private static final String LAST_MODIFIED_BY = "jcr:lastModifiedBy";
    private static final String DESCRIPTION = "jcr:description";
    private static final String TITLE = "jcr:title";
    private static final String CREATED = "jcr:created";
    private static final String LAST_ACTION = "hl:lastAction";
    private static final String LAST_MODIFIED = "jcr:lastModified";
    protected final JCRWorkspace workspace;
    protected String identifier;
    protected Calendar creationDate;
    protected static GCUBEClientLog logger = new GCUBEClientLog(JCRWorkspaceItem.class, new Properties[0]);

    public JCRWorkspaceItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        this.workspace = workspace;
        this.identifier = node.getIdentifier();
        this.creationDate = node.getProperty(CREATED).getDate();
    }

    public JCRWorkspaceItem(JCRWorkspace workspace, Node node, String name, String description) throws RepositoryException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)description, (String)"Description must be not null");
        this.workspace = workspace;
        node.setProperty(LAST_MODIFIED_BY, workspace.getOwner().getPortalLogin());
        node.setProperty(DESCRIPTION, description);
        node.setProperty(TITLE, name);
        node.setProperty(LAST_ACTION, WorkspaceItemAction.CREATED.toString());
    }

    public void save(Node node) throws RepositoryException {
        node.getSession().save();
        this.identifier = node.getIdentifier();
        this.creationDate = node.getProperty(CREATED).getDate();
    }

    public String getId() throws InternalErrorException {
        return this.identifier;
    }

    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String name;
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = name = node.getProperty(TITLE).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getDescription() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getProperty(DESCRIPTION).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setDescription(String description) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            this.internalDescription(session.getNodeByIdentifier(this.identifier), description);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void rename(String name) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        if (!this.workspace.isValidName(name)) {
            throw new IllegalArgumentException("Invalid item name");
        }
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            this.internalRename(node, name);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Calendar getCreationTime() throws InternalErrorException {
        return this.creationDate;
    }

    public Calendar getLastModificationTime() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Calendar calendar = node.getProperty(LAST_MODIFIED).getDate();
            return calendar;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItemAction getLastAction() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            WorkspaceItemAction workspaceItemAction = WorkspaceItemAction.valueOf((String)node.getProperty(LAST_ACTION).getString());
            return workspaceItemAction;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public WorkspaceFolder getParent() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            WorkspaceFolder workspaceFolder = this.workspace.getParent(session.getNodeByIdentifier(this.identifier));
            return workspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private WorkspaceFolder getParent(Node node) throws InternalErrorException {
        try {
            return this.workspace.getParent(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getPath() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String string = this.getPath(session.getNodeByIdentifier(this.identifier));
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getPath(Node node) throws RepositoryException, InternalErrorException {
        if (this.isRoot(node)) {
            return this.workspace.getPathSeparator() + node.getProperty(TITLE).getString();
        }
        return ((JCRWorkspaceFolder)this.getParent(node)).getPath(node.getParent()) + this.workspace.getPathSeparator() + node.getProperty(TITLE).getString();
    }

    public boolean isRoot() throws InternalErrorException {
        return this.getParent() == null;
    }

    public boolean isRoot(Node node) throws RepositoryException, InternalErrorException {
        return this.workspace.getParent(node) == null;
    }

    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        try {
            this.workspace.removeItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void move(WorkspaceFolder destination) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        Validate.notNull((Object)destination, (String)"Destination must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(destination.getId());
            this.internalMove(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public WorkspaceItem cloneItem(String cloneName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        Validate.notNull((Object)cloneName, (String)"Clone name must be not null");
        if (!this.workspace.isValidName(cloneName)) {
            throw new IllegalArgumentException("Clone name is not valid");
        }
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRWorkspaceItem jCRWorkspaceItem = this.workspace.getWorkspaceItem(this.internalCopy(node.getParent(), cloneName));
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        Node node = nodeFolder.getSession().getNodeByIdentifier(this.identifier);
        String pathNewNode = nodeFolder.getPath() + "/" + Text.escapeIllegalJcrChars((String)newName);
        try {
            if (node.getSession().getNode(pathNewNode) != null) {
                throw new ItemAlreadyExistException(newName + " already exist");
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            node.getSession().getWorkspace().copy(node.getPath(), pathNewNode);
            Node newNode = node.getSession().getNode(pathNewNode);
            newNode.setProperty(LAST_MODIFIED, Calendar.getInstance());
            newNode.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            newNode.setProperty(TITLE, newName);
            newNode.setProperty(LAST_ACTION, WorkspaceItemAction.CLONED.toString());
            newNode.getSession().save();
            return newNode;
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug((Object)("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getIdentifier()));
            Node node = destinationFolderNode.getSession().getNodeByIdentifier(this.identifier);
            if (this.workspace.exists(node.getName(), destinationFolderNode.getIdentifier())) {
                logger.error((Object)("Item with name " + this.getName() + " exists"));
                throw new ItemAlreadyExistException("Item " + node.getName() + " already exists");
            }
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.setProperty(LAST_ACTION, WorkspaceItemAction.MOVED.toString());
            node.getSession().save();
            node.getSession().getWorkspace().move(node.getPath(), destinationFolderNode.getPath() + "/" + node.getName());
        }
        catch (RepositoryException e) {
            logger.error((Object)"Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalRename(Node node, String newName) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            logger.debug((Object)("Internal rename item with id " + this.getId() + " to destination item with id " + node.getParent().getIdentifier()));
            if (this.workspace.exists(nodeNewName, node.getParent().getIdentifier())) {
                logger.error((Object)("Item with name " + nodeNewName + " exists"));
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            String newPath = node.getParent().getPath() + this.workspace.getPathSeparator() + nodeNewName;
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.setProperty(LAST_ACTION, WorkspaceItemAction.RENAMED.toString());
            node.setProperty(TITLE, newName);
            node.getSession().save();
            String path = node.getPath();
            node.getSession().getWorkspace().move(path, newPath);
        }
        catch (RepositoryException e) {
            logger.error((Object)"Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalDescription(Node node, String newDescription) throws InternalErrorException {
        Validate.notNull((Object)newDescription, (String)"Description must be not null");
        try {
            node.setProperty(DESCRIPTION, newDescription);
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

