package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;

public class JCRFolderBulkCreatorManager implements FolderBulkCreatorManager {

	private GCUBEClientLog logger;
	private final JCRWorkspace workspace;
	
	protected Map<String, Thread> threads = new LinkedHashMap<String, Thread>();
	
	public JCRFolderBulkCreatorManager(JCRWorkspace workspace) {
		
		logger = new GCUBEClientLog(this);
		this.workspace = workspace;
	}
	
	public FolderBulkCreator getFolderBulk(JCRWorkspaceFolder destinationFolder) throws InternalErrorException {
		
		String name = UUID.randomUUID().toString();
		return new JCRFolderBulkCreator(name,
					destinationFolder, this);
	}
	
	public void removeThread(String id) throws InternalErrorException {
		threads.remove(id);		
	}
	
	public void addFolderBulkCreator(FolderBulkCreator folderBulk, Thread th) throws InternalErrorException {
		
		threads.put(folderBulk.getId(), th);
	}
	
	@Override
	public List<FolderBulkCreator> getActiveFolderBulkCreators() {
		
		LinkedList<FolderBulkCreator> list = new LinkedList<FolderBulkCreator>();
		Session session = null;
		try { 
			session = JCRRepository.getSession();
			Node rootCreator = workspace.getRepository().
					getRootFolderBulkCreators(session);
			for(NodeIterator iterator = rootCreator.getNodes(); iterator.hasNext();) {
				Node node = iterator.nextNode();
				list.add(new JCRFolderBulkCreator(workspace, node, this));
			}
			
		} catch (Exception e) {
			logger.error(e);
		} finally {
			if(session != null)
				session.logout();
		}
		return list;
	}
	
	@Override
	public FolderBulkCreator getActiveFolderBulkCreator(String id) throws InternalErrorException {
		
		Session session = JCRRepository.getSession();
		try { 
			Node rootCreator = workspace.getRepository().
					getRootFolderBulkCreators(session);
			return new JCRFolderBulkCreator(workspace,rootCreator.getNode(id),this);
		} catch (RepositoryException e) {
			logger.error(e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}
	

	@Override
	public void waitFolderBulkCreator(String id) throws InterruptedException{
		Thread th = threads.get(id);
		if (th!=null) th.join();
	}

}
