package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.ServiceLoader;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.rpc.server.ServiceLifecycle;

import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Properties;
import org.gcube.portlets.user.homelibrary.home.workspace.ExternalResourceLinkPlugin;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourceBrokenLinkException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourcePluginNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.jcr.JCRExternalResourcePluginManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRExternalResourceLink extends JCRWorkspaceFolderItem implements ExternalResourceLink {

	private static final String NT_CONTENT 		= "nthl:externalResourceLinkContent";
	
	private static final String MIME_TYPE 		= "hl:mimeType";
	private static final String RESOURCE_ID 	= "hl:resourceId";
	private static final String PLUGIN 			= "hl:servicePlugin"; 
	
	private String mimeType;
	private String resourceId;
	private String plugin;
	
	public JCRExternalResourceLink(JCRWorkspace workspace, Node node)
			throws RepositoryException {
		super(workspace, node);
		
		Node contentNode = node.getNode(CONTENT);
		this.mimeType = contentNode.getProperty(MIME_TYPE).getString();
		this.resourceId = contentNode.getProperty(RESOURCE_ID).getString();
		this.plugin = contentNode.getProperty(PLUGIN).getString();
	}

	public JCRExternalResourceLink(JCRWorkspace workspace, Node node, String name, String mimeType, 
			String description, String resourceId, String plugin) throws RepositoryException {
		super(workspace, node, name, description);
		
		this.mimeType = mimeType;
		this.resourceId = resourceId;
		this.plugin = plugin;
		
		Node contentNode = node.addNode(CONTENT, NT_CONTENT);
		contentNode.setProperty(MIME_TYPE, mimeType);
		contentNode.setProperty(RESOURCE_ID, resourceId);
		contentNode.setProperty(PLUGIN, plugin);
		
	}
	
	@Override
	public String getMimeType() {
		return mimeType;
	}

	@Override
	public InputStream getData() throws InternalErrorException,
	ExternalResourceBrokenLinkException, ExternalResourcePluginNotFoundException {
		

//		ServiceLoader<ExternalResourceLinkPlugin> serviceLoader = ServiceLoader.load(ExternalResourceLinkPlugin.class); 
//		for (ExternalResourceLinkPlugin plugin : serviceLoader) {
//			System.out.println("Plugin found" + plugin.getPluginName());
//			if(plugin.getPluginName().toLowerCase().equals(this.plugin.toLowerCase())) {
//				return plugin.getContent(this);
//			}
//		}
		ExternalResourceLinkPlugin plugin =
				JCRExternalResourcePluginManager.getPlugin(this.plugin);
		return plugin.getContent(this);
			
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		return;
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.SERVICE_RESOURCE_LINK;
	}


	@Override
	public String getResourceId() {
		return this.resourceId;
	}

	@Override
	public String getExternalResourcePlugin() {
		return plugin;
	}

	@Override
	public long getLength() throws InternalErrorException {
		return 0;
	}

}
