/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Properties;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;

public class JCRProperties
implements Properties {
    private static GCUBELog logger = new GCUBELog(JCRProperties.class);
    private static final String PROPERTIES = "hl:metadata";
    private String identifier;

    public JCRProperties(Node itemNode) throws RepositoryException {
        this.identifier = itemNode.getIdentifier();
    }

    public String getId() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getNode(PROPERTIES).getIdentifier();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getPropertyValue(String propertyName) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node itemNode = session.getNodeByIdentifier(this.identifier);
            String string = itemNode.getNode(PROPERTIES).getProperty(propertyName).getString();
            return string;
        }
        catch (PathNotFoundException e) {
            String string = null;
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Map<String, String> getProperties() throws InternalErrorException {
        HashMap<String, String> map = new HashMap<String, String>();
        Session session = JCRRepository.getSession();
        Node itemNode = null;
        try {
            itemNode = session.getNodeByIdentifier(this.identifier);
            Node propertiesNode = itemNode.getNode(PROPERTIES);
            Object iterator = propertiesNode.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                if (property.getName().startsWith("jcr:")) continue;
                String unescapeName = Text.unescape((String)property.getName());
                map.put(unescapeName, property.getValue().toString());
            }
            iterator = Collections.unmodifiableMap(map);
            return iterator;
        }
        catch (PathNotFoundException e) {
            if (itemNode != null) {
                try {
                    itemNode.addNode(PROPERTIES);
                    session.save();
                    HashMap<String, String> iterator = map;
                    return iterator;
                }
                catch (RepositoryException e1) {
                    logger.error((Object)"Error to add properties ", (Throwable)e1);
                    throw new InternalErrorException(e1.getMessage());
                }
            }
            throw new InternalErrorException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void addProperty(String name, String value) throws InternalErrorException {
        Validate.notNull((Object)name, (String)"Name property must be not null");
        Validate.notNull((Object)value, (String)"Value property must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node itemNode = session.getNodeByIdentifier(this.identifier);
            String escapeName = Text.escapeIllegalJcrChars((String)name);
            itemNode.getNode(PROPERTIES).setProperty(escapeName, value);
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }
}

