/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.home.manager.HomeLibraryManager;
import org.gcube.portlets.user.homelibrary.jcr.JCRExternalResourcePluginManager;
import org.gcube.portlets.user.homelibrary.jcr.JCRHomeManager;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;

public class JCRHomeManagerFactory
implements HomeManagerFactory {
    private static GCUBEClientLog logger;
    private static HomeManager homeManager;
    private static File persistenceFolder;

    public void initialize(String pathPersistenceFolder) throws InternalErrorException {
        logger = new GCUBEClientLog((Object)this, new Properties[0]);
        persistenceFolder = new File(pathPersistenceFolder);
        if (!persistenceFolder.exists()) {
            persistenceFolder.mkdirs();
        }
        logger.debug((Object)"Initialize content manager");
        try {
            JCRRepository.Initialize();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        JCRExternalResourcePluginManager.initialize();
        homeManager = new JCRHomeManager(this, persistenceFolder);
    }

    public File getPersistenceFolder() {
        return persistenceFolder;
    }

    public List<String> listScopes() throws InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        return list;
    }

    public boolean exists(String scope) throws InternalErrorException {
        return false;
    }

    public HomeLibraryManager getHomeLibraryManager() throws InternalErrorException {
        return null;
    }

    public List<String> listUserScopes(String portalLogin) throws InternalErrorException {
        try {
            Home home = homeManager.getHome(portalLogin, null);
            return home.listScopes();
        }
        catch (HomeNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<String> listInfrastructureScopes() throws InternalErrorException {
        return null;
    }

    public List<String> listInfrastructureScopeUsers(String scope) throws InternalErrorException {
        return null;
    }

    public void shutdown() throws InternalErrorException {
    }

    public HomeManager getHomeManager() throws InternalErrorException {
        logger.debug((Object)"getHomeManager");
        return homeManager;
    }

    public void removeHomeManager() throws InternalErrorException {
    }

    public HomeManager getHomeManager(String scope) throws InternalErrorException {
        return this.getHomeManager();
    }
}

