package org.gcube.portlets.user.homelibrary.jcr;


import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.home.manager.HomeLibraryManager;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;

public class JCRHomeManagerFactory implements HomeManagerFactory {
	
	private static GCUBEClientLog logger;
	private static HomeManager homeManager;
	private static File persistenceFolder;
	
	@Override
	public void initialize(String pathPersistenceFolder)
			throws InternalErrorException {
		
		logger = new GCUBEClientLog(this);
				
//		persistenceFolder = new File(pathPersistenceFolder);
//		
//		if(!persistenceFolder.exists()) {
//			persistenceFolder.mkdirs();
//		}
		
		logger.debug("Initialize content manager");
		try {
			JCRRepository.Initialize();
		} catch (Exception e) {
			throw new InternalErrorException(e);
		}
		
		JCRExternalResourcePluginManager.initialize();
		
		homeManager = new JCRHomeManager(this, persistenceFolder);
	}

	public File getPersistenceFolder() {
		return persistenceFolder;
	}
	
	@Override
	public List<String> listScopes() throws InternalErrorException {
		//TODO e.g.
		List<String> list = new LinkedList<String>();
//		list.add("/gcube/devsec");
//		list.add("/gcube/devNext");
//		list.add("/gcube/devNext/NextNext");
//		list.add("/gcube/devsec/devVRE");
		return list;
	}
	@Override
	public boolean exists(String scope) throws InternalErrorException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public HomeLibraryManager getHomeLibraryManager()
			throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<String> listUserScopes(String portalLogin)
			throws InternalErrorException {
		
		try {
			Home home = homeManager.getHome(portalLogin, null);
			return home.listScopes();
		} catch (HomeNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (UserNotFoundException e) {
			throw new InternalErrorException(e);
		}
		
	}

	@Override
	public List<String> listInfrastructureScopes()
			throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<String> listInfrastructureScopeUsers(String scope)
			throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void shutdown() throws InternalErrorException {
		

	}

	@Override
	public HomeManager getHomeManager()
			throws InternalErrorException {
		logger.debug("getHomeManager");
		return homeManager;
	}

	@Override
	public void removeHomeManager()
			throws InternalErrorException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public HomeManager getHomeManager(String scope)
			throws InternalErrorException {
		return getHomeManager();
	}

}
