package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.util.ArrayList;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Properties;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceItem;

public abstract class JCRWorkspaceFolderItem extends JCRWorkspaceItem implements
		FolderItem {
	
	
	protected static final String WORKFLOW_ID 		= "hl:workflowId";
	protected static final String WORKFLOW_STATUS 	= "hl:workflowStatus";
	protected static final String WORKFLOW_DATA 	= "hl:workflowData"; 

//	private static final String OWNER 				= "hl:owner";
//	private static final String SCOPE               = "hl:scope";
//	private static final String PORTAL_LOGIN  		= "hl:portalLogin";
//	private static final String USER_ID 			= "hl:uuid";
	
	protected static final String CONTENT			= "jcr:content";
	protected static final String FOLDER_ITEM_TYPE 	= "hl:workspaceItemType";
	
	public JCRWorkspaceFolderItem(JCRWorkspace workspace, Node node) throws RepositoryException {
		super(workspace, node);
	}
	
	public JCRWorkspaceFolderItem(JCRWorkspace workspace, Node node,
			String name, String description) throws RepositoryException {
		super(workspace, node, name, description);
		
		node.setProperty(WORKFLOW_ID, "");
		node.setProperty(WORKFLOW_STATUS, "");
		node.setProperty(WORKFLOW_DATA, "");
		
//		Node nodeOwner = node.getNode(OWNER);
//		nodeOwner.setProperty(SCOPE,workspace.getOwner().getScope().toString());
//		nodeOwner.setProperty(PORTAL_LOGIN,workspace.getOwner().getPortalLogin());
//		nodeOwner.setProperty(USER_ID,workspace.getOwner().getId());
		
	}
	
	@Override
	public void save(Node node) throws RepositoryException {
		super.save(node);

		Node contentNode = node.getNode(CONTENT);
		saveContent(contentNode);
	}

	abstract public void saveContent(Node node) throws RepositoryException;
	
	@Override
	public WorkspaceItemType getType() {
		
		return WorkspaceItemType.FOLDER_ITEM;
	}
	
	@Override
	public abstract FolderItemType getFolderItemType();
	
	@Override
	public abstract long getLength() throws InternalErrorException;
	
	
	@Override
	public  List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
		return new ArrayList<WorkspaceItem>();
	}
	
	
	@Override
	public void removeChild(WorkspaceItem child) {
		return;
	}

	@Override
	public String getWorkflowId() throws InternalErrorException {
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(identifier);
			return node.getProperty(WORKFLOW_ID).getString();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public void setWorkflowId(String id) throws InternalErrorException {	
		setWorkflowProperty(WORKFLOW_ID, id);
	}
		
	@Override
	public String getWorkflowStatus() throws InternalErrorException {
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(identifier);
			return node.getProperty(WORKFLOW_STATUS).getString();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public void setWorkflowStatus(String status) throws InternalErrorException {
		setWorkflowProperty(WORKFLOW_STATUS, status);
	}

	@Override
	public String getWorkflowData() throws InternalErrorException {
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(identifier);
			return node.getProperty(WORKFLOW_DATA).getString();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public void setWorkflowData(String data) throws InternalErrorException {
		setWorkflowProperty(WORKFLOW_DATA, data);
	}
	
	private final void setWorkflowProperty(String property, String value) throws InternalErrorException {
		
		Session session = JCRRepository.getSession();
		try {
			session.getNodeByIdentifier(identifier).setProperty(property, value);
			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}
	
	@Override
	public Properties getProperties() throws InternalErrorException {
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(identifier);
			return new JCRProperties(node);
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

}
