package org.gcube.portlets.user.homelibrary.jcr.workspace.search;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchFolder;

public class JCRSearchFolder implements SearchFolder {

	private static final String CREATED 			= "jcr:created";
	private static final String   TITLE    		    = "jcr:title";
	
	private final String id;
	private final String name;
	private final Calendar creationDate;

	public JCRSearchFolder(Node node) throws RepositoryException{
		
		this.id = node.getIdentifier();
		this.name = node.getProperty(TITLE).getString();
		this.creationDate = node.getProperty(CREATED).getDate();
	}
	
	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public Calendar getCreationDate() {
		return creationDate;
	}

	@Override
	public WorkspaceItemType getType() {
		
		return WorkspaceItemType.FOLDER;
	}
	
}
