/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.Calendar;
import java.util.Properties;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemAccounting;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public abstract class JCRWorkspaceItem
implements WorkspaceItem {
    protected static final String LAST_MODIFIED_BY = "jcr:lastModifiedBy";
    protected static final String DESCRIPTION = "jcr:description";
    protected static final String TITLE = "jcr:title";
    protected static final String CREATED = "jcr:created";
    protected static final String LAST_ACTION = "hl:lastAction";
    protected static final String LAST_MODIFIED = "jcr:lastModified";
    protected static final String READERS = "hl:readers";
    private static final String OWNER = "hl:owner";
    private static final String SCOPE = "hl:scope";
    private static final String PORTAL_LOGIN = "hl:portalLogin";
    private static final String USER_ID = "hl:uuid";
    private static final String NT_USER = "nthl:user";
    protected final JCRWorkspace workspace;
    protected String identifier;
    protected Calendar creationDate;
    protected static GCUBEClientLog logger = new GCUBEClientLog(JCRWorkspaceItem.class, new Properties[0]);

    public JCRWorkspaceItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        this.workspace = workspace;
        this.identifier = node.getIdentifier();
        this.creationDate = node.getProperty(CREATED).getDate();
    }

    public JCRWorkspaceItem(JCRWorkspace workspace, Node node, String name, String description) throws RepositoryException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)description, (String)"Description must be not null");
        this.workspace = workspace;
        node.setProperty(LAST_MODIFIED_BY, workspace.getOwner().getPortalLogin());
        node.setProperty(DESCRIPTION, description);
        node.setProperty(TITLE, name);
        node.setProperty(LAST_ACTION, WorkspaceItemAction.CREATED.toString());
        Node nodeOwner = null;
        try {
            nodeOwner = node.getNode(OWNER);
        }
        catch (PathNotFoundException e) {
            nodeOwner = node.addNode(OWNER, NT_USER);
        }
        this.setOwnerNode(nodeOwner);
    }

    protected void setOwnerNode(Node nodeOwner) throws RepositoryException {
        nodeOwner.setProperty(SCOPE, this.workspace.getOwner().getScope() != null ? this.workspace.getOwner().getScope().toString() : null);
        nodeOwner.setProperty(PORTAL_LOGIN, this.workspace.getOwner().getPortalLogin());
        nodeOwner.setProperty(USER_ID, this.workspace.getOwner().getId());
    }

    public User getOwner() {
        Session session = null;
        Node node = null;
        try {
            session = JCRRepository.getSession();
            node = session.getNodeByIdentifier(this.identifier);
            Node nodeOwner = node.getNode(OWNER);
            JCRUser jCRUser = new JCRUser(nodeOwner.getProperty(USER_ID).getString(), nodeOwner.getProperty(PORTAL_LOGIN).getString(), GCUBEScope.getScope((String)nodeOwner.getProperty(SCOPE).getString()));
            return jCRUser;
        }
        catch (PathNotFoundException e) {
            try {
                Node nodeOwner = node.addNode(OWNER, NT_USER);
                this.setOwnerNode(nodeOwner);
                User user = this.workspace.getOwner();
                return user;
            }
            catch (RepositoryException e1) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        finally {
            session.logout();
        }
    }

    public void save(Node node) throws RepositoryException {
        node.getSession().save();
        this.identifier = node.getIdentifier();
        this.creationDate = node.getProperty(CREATED).getDate();
    }

    public String getId() throws InternalErrorException {
        return this.identifier;
    }

    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String name;
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = name = node.getProperty(TITLE).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getDescription() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getProperty(DESCRIPTION).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setDescription(String description) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                this.internalDescription(session.getNodeByIdentifier(this.identifier), description);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void rename(String name) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.renameItem(this.getId(), name);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Calendar getCreationTime() throws InternalErrorException {
        return this.creationDate;
    }

    public Calendar getLastModificationTime() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Calendar calendar = node.getProperty(LAST_MODIFIED).getDate();
            return calendar;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItemAction getLastAction() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            WorkspaceItemAction workspaceItemAction = WorkspaceItemAction.valueOf((String)node.getProperty(LAST_ACTION).getString());
            return workspaceItemAction;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public org.gcube.portlets.user.homelibrary.home.workspace.Properties getProperties() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRProperties jCRProperties = new JCRProperties(node);
            return jCRProperties;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItemAccounting getAccounting() {
        return null;
    }

    public WorkspaceFolder getParent() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            JCRAbstractWorkspaceFolder jCRAbstractWorkspaceFolder = this.workspace.getParent(session.getNodeByIdentifier(this.identifier));
            return jCRAbstractWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    protected JCRAbstractWorkspaceFolder getParent(Node node) throws InternalErrorException {
        try {
            return this.workspace.getParent(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isShared() throws InternalErrorException {
        return this.getIdSharedFolder() != null;
    }

    public String getIdSharedFolder() throws InternalErrorException {
        if (this.isRoot()) {
            return null;
        }
        if (this.getType() == WorkspaceItemType.SHARED_FOLDER) {
            return this.getId();
        }
        return ((JCRWorkspaceItem)this.getParent()).getIdSharedFolder();
    }

    public String getPath() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String string = this.getPath(session.getNodeByIdentifier(this.identifier));
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getPath(Node node) throws RepositoryException, InternalErrorException {
        if (this.isRoot(node)) {
            return String.valueOf(this.workspace.getPathSeparator()) + node.getProperty(TITLE).getString();
        }
        return String.valueOf(this.getParent(node).getPath(node.getParent())) + this.workspace.getPathSeparator() + node.getProperty(TITLE).getString();
    }

    public boolean isRoot() throws InternalErrorException {
        return this.getParent() == null;
    }

    public boolean isRoot(Node node) throws RepositoryException, InternalErrorException {
        return this.workspace.getParent(node) == null;
    }

    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        try {
            this.workspace.removeItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void move(WorkspaceFolder destination) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.moveItem(this.getId(), destination.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem cloneItem(String cloneName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            return this.workspace.cloneItem(this.getId(), cloneName);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        Node node = nodeFolder.getSession().getNodeByIdentifier(this.identifier);
        String pathNewNode = String.valueOf(nodeFolder.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
        try {
            if (node.getSession().getNode(pathNewNode) != null) {
                throw new ItemAlreadyExistException(String.valueOf(newName) + " already exist");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        try {
            node.getSession().getWorkspace().copy(node.getPath(), pathNewNode);
            Node newNode = node.getSession().getNode(pathNewNode);
            newNode.setProperty(LAST_MODIFIED, Calendar.getInstance());
            newNode.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            newNode.setProperty(TITLE, newName);
            newNode.setProperty(LAST_ACTION, WorkspaceItemAction.CLONED.toString());
            newNode.getSession().save();
            return newNode;
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug((Object)("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getIdentifier()));
            Node node = destinationFolderNode.getSession().getNodeByIdentifier(this.identifier);
            if (this.workspace.exists(node.getName(), destinationFolderNode.getIdentifier())) {
                logger.error((Object)("Item with name " + this.getName() + " exists"));
                throw new ItemAlreadyExistException("Item " + node.getName() + " already exists");
            }
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.setProperty(LAST_ACTION, WorkspaceItemAction.MOVED.toString());
            node.getSession().save();
            node.getSession().getWorkspace().move(node.getPath(), String.valueOf(destinationFolderNode.getPath()) + this.workspace.getPathSeparator() + node.getName());
        }
        catch (RepositoryException e) {
            logger.error((Object)"Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalRename(Node node, String newName) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            logger.debug((Object)("Internal rename item with id " + this.getId() + " to destination item with id " + node.getParent().getIdentifier()));
            if (this.workspace.exists(nodeNewName, node.getParent().getIdentifier())) {
                logger.error((Object)("Item with name " + nodeNewName + " exists"));
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            String newPath = String.valueOf(node.getParent().getPath()) + this.workspace.getPathSeparator() + nodeNewName;
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.setProperty(LAST_ACTION, WorkspaceItemAction.RENAMED.toString());
            node.setProperty(TITLE, newName);
            node.getSession().save();
            String path = node.getPath();
            node.getSession().getWorkspace().move(path, newPath);
        }
        catch (RepositoryException e) {
            logger.error((Object)"Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.fatal((Object)"Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalDescription(Node node, String newDescription) throws InternalErrorException {
        Validate.notNull((Object)newDescription, (String)"Description must be not null");
        try {
            node.setProperty(DESCRIPTION, newDescription);
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isMarkedAsRead() throws InternalErrorException {
        if (this.getOwner().getPortalLogin().equals(this.workspace.getOwner().getPortalLogin())) {
            return true;
        }
        Session session = JCRRepository.getSession();
        try {
            boolean bl = this.existReader(session);
            return bl;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private boolean existReader(Session session) throws RepositoryException, InternalErrorException {
        Node node = session.getNodeByIdentifier(this.getId());
        Property property = null;
        try {
            property = node.getProperty(READERS);
        }
        catch (PathNotFoundException e) {
            property = node.setProperty(READERS, new String[0]);
            session.save();
            return false;
        }
        Value[] valueArray = property.getValues();
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            if (value.getString().equals(this.workspace.getOwner().getPortalLogin())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void markAsRead(boolean read) throws InternalErrorException {
        if (this.getOwner().getPortalLogin().equals(this.workspace.getOwner().getPortalLogin())) {
            return;
        }
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                if (read) {
                    if (!this.existReader(session)) {
                        Property readers = node.getProperty(READERS);
                        String[] newReaders = new String[readers.getValues().length + 1];
                        newReaders[0] = this.workspace.getOwner().getPortalLogin();
                        int i = 1;
                        while (i < newReaders.length) {
                            newReaders[i] = readers.getValues()[i - 1].getString();
                            ++i;
                        }
                        node.setProperty(READERS, newReaders);
                    }
                } else if (this.existReader(session)) {
                    Property readers = node.getProperty(READERS);
                    String[] newReaders = new String[readers.getValues().length - 1];
                    int i = 0;
                    Value[] valueArray = readers.getValues();
                    int n = valueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Value value = valueArray[n2];
                        if (!this.workspace.getOwner().getPortalLogin().equals(value.getString())) {
                            newReaders[i++] = value.getString();
                        }
                        ++n2;
                    }
                    node.setProperty(READERS, newReaders);
                }
                session.save();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }
}

