package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.ImageDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.PDFDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;

public abstract class JCRAbstractWorkspaceFolder extends JCRWorkspaceItem implements WorkspaceFolder {

	public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, Node node) throws RepositoryException {
		super(workspace,node);
		
	}
	
	public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, Node node,
			String name, String description) throws RepositoryException  {		
		super(workspace,node,name,description);
	}
	
	public JCRWorkspace getWorkspace() {
		return workspace;
	}
	
	
	@Override
	public abstract WorkspaceItemType getType();
		

	@Override
	public boolean exists(String name) throws InternalErrorException {
		
		try {
			return workspace.exists(name, getId());
		} catch (ItemNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongItemTypeException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public WorkspaceItem find(String name) throws InternalErrorException {
		try {
			return workspace.find(name, getId());
		} catch (ItemNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongItemTypeException e) {
			throw new InternalErrorException(e);
		}
	}
	
	@Override
	public List<WorkspaceItem> getChildren() {
		
		List<WorkspaceItem> children = new ArrayList<WorkspaceItem>();
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			try {
				

				Node folderNode = session.getNodeByIdentifier(identifier);
				NodeIterator iterator = folderNode.getNodes();
				
				for(; iterator.hasNext();) {

					Node node = (Node)iterator.next();
					String nodeType = node.getPrimaryNodeType().getName();
					try {
						
						if(nodeType.startsWith("rep:")) { 
							continue;
						}
				
						WorkspaceItem item = (workspace).getWorkspaceItem(node);

						if((workspace.getScope() != null) && (item.getType() == WorkspaceItemType.FOLDER_ITEM) 
								&& !(item.getOwner().getScope().toString()).equals(workspace.getScope().toString()))
							continue;

						children.add(item);
					} catch (InternalErrorException e) {
						// TODO logger
						//						logger.error("Node not retrieved with type " + nodeType,e);
					} catch (RepositoryException e) {
						// TODO logger
						// logger.error("Node not retrieved with type " + nodeType,e);
					}
				}
			} catch (RepositoryException e) {
				logger.error("No nodes retrieved",e);
			}
		} catch (InternalErrorException e) {
			logger.error("Session problem",e);
		} finally {
			if (session != null)
				session.logout();
		}
		return children;
	}

	@Override
	public WorkspaceFolder createFolder(String name, String description)
			throws InternalErrorException, InsufficientPrivilegesException,
			ItemAlreadyExistException {
		
		try {
			return workspace.createFolder(name, description, getId());
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (ItemNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		}	 
	}

	@Override
	public ExternalImage createExternalImageItem(String name,
			String description, String mimeType, InputStream imageData)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		try {
			return workspace.createExternalImage(name, description, mimeType,
					imageData, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public ExternalFile createExternalFileItem(String name, String description,
			String mimeType, InputStream fileData)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		
		try {
			return workspace.createExternalFile(name, description, mimeType, fileData,
					getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public ExternalPDFFile createExternalPDFFileItem(String name,
			String description, String mimeType, InputStream fileData)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		try {
			return workspace.createExternalPDFFile(name, description, mimeType, fileData,
					getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public ExternalUrl createExternalUrlItem(String name, String description,
			String url) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createExternalUrl(name, description, url,
					getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public ExternalUrl createExternalUrlItem(String name, String description,
			InputStream url) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createExternalUrl(name, description, url,
					getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public ReportTemplate createReportTemplateItem(String name,
			String description, Calendar created, Calendar lastEdit,
			String author, String lastEditBy, int numberOfSections,
			String status, InputStream templateData)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		
		try {
			
			return workspace.createReportTemplate(name, description, created, lastEdit,
					author, lastEditBy, numberOfSections, status, templateData, getId());
			
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public Report createReportItem(String name, String description,
			Calendar created, Calendar lastEdit, String author,
			String lastEditBy, String templateName, int numberOfSections,
			String status, InputStream reportData)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		
		try {
			return workspace.createReport(name, description, created, lastEdit,
					author, lastEditBy, templateName, numberOfSections, status,
					reportData,getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public Query createQueryItem(String name, String description, String query,
			QueryType queryType) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createQuery(name, description, query, queryType, getId());
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public Query createQueryItem(String name, String description,
			InputStream query, QueryType queryType)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		
		try {
			return workspace.createQuery(name, description, query, queryType, getId());
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public WorkspaceFolder createAquaMapsItem(String name, String description,
			String mapName, String mapType, String author, int numberOfSpecies,
			String boundingBox, float psoThreshold,
			int numberOfGeneratedImages, InputStream metadata,
			Map<String, InputStream> images)
			throws InsufficientPrivilegesException,
			WorkspaceFolderNotFoundException, InternalErrorException,
			ItemAlreadyExistException, WrongDestinationException {
	
		return workspace.createAquaMapsItem(name, description, mapName, mapType,
				author, numberOfSpecies, boundingBox, psoThreshold, numberOfGeneratedImages,
				metadata, images, getId());
	}

	@Override
	public Annotation createAnnotationItem(String name, String description,
			String oid, Map<String, String> data)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Metadata createMetadataItem(String name, String description,
			String oid, String schema, String language, String metadata,
			String collectionName) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createMetadata(name, description, oid, schema, language, metadata,
					collectionName, getId());
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public Document createDocumentItem(String name, String description,
			String oid, String mimeType, InputStream documentData,
			Map<String, String> metadata, Map<String, String> annotations,
			String collectionName) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createDocument(name, description, oid, mimeType,
					documentData, metadata, annotations, collectionName, getId());
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public ImageDocument createImageDocumentItem(String name,
			String description, String oid, String mimeType,
			InputStream imageData, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		
		try {
			return workspace.createImageDocument(name, description, oid, mimeType,
					imageData, metadata, annotations, collectionName, getId());
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public PDFDocument createPDFDocumentItem(String name, String description,
			String oid, String mimeType, InputStream data,
			Map<String, String> metadata, Map<String, String> annotations,
			String collectionName) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		try {
			return workspace.createPDFDocument(name, description, oid, mimeType, data,
					metadata, annotations, collectionName, getId());
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public UrlDocument createUrlDocumentItem(String name, String description,
			String oid, String mimeType, InputStream documentData,
			Map<String, String> metadata, Map<String, String> annotations,
			String collectionName) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createUrlDocument(name, description, oid, mimeType,
					documentData, metadata, annotations, collectionName, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public DocumentLink createDocumentLinkItem(String name, String description,
			String oid, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName,
			String mimeType) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		try {
			return workspace.createDocumentLink(name, description, oid, metadata,
					annotations, collectionName, mimeType, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public ImageDocumentLink createImageDocumentLinkItem(String name,
			String description, String oid, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName,
			String mimeType) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createImageDocumentLink(name, description, oid,
					metadata, annotations, collectionName, mimeType, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public PDFDocumentLink createPDFDocumentLinkItem(String name,
			String description, String oid, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName,
			String mimeType) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
	
		try {
			return workspace.createPDFDocumentLink(name, description, oid,
					metadata, annotations, collectionName, mimeType, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public TimeSeries createTimeSeries(String name, String description,
			String timeseriesId, String title, String creator,
			String timeseriesDescription, String timeseriesCreationDate,
			String publisher, String sourceId, String sourceName,
			String rights, long dimension, List<String> headerLabels,
			InputStream compressedCSV) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createTimeSeries(name, description, timeseriesId, title,
					creator, timeseriesDescription, timeseriesCreationDate, publisher,
					sourceId, sourceName, rights, dimension, headerLabels, compressedCSV,
					getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public WorkflowReport createWorkflowReport(String name, String description,
			String workflowId, String workflowStatus, String workflowData)
			throws InsufficientPrivilegesException, InternalErrorException,
			ItemAlreadyExistException {
		
		try {
			return workspace.createWorkflowReport(name, description, workflowId, workflowStatus,
					workflowData, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public WorkflowTemplate createWorkflowTemplate(String name,
			String description, String workflowId, String workflowStatus,
			String workflowData) throws InsufficientPrivilegesException,
			InternalErrorException, ItemAlreadyExistException {
		
		try {
			return workspace.createWorkflowTemplate(name, description, workflowId, workflowStatus,
					workflowData, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public FolderBulkCreator getNewFolderBulkCreator()
			throws InternalErrorException {
		
		try {
			return workspace.getNewFolderBulkCreator(getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongItemTypeException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public void removeChild(WorkspaceItem child) throws InternalErrorException,
			InsufficientPrivilegesException {
		
		try {
			workspace.removeItem(child.getId());
		} catch (ItemNotFoundException e) {
			throw new InternalErrorException(e);
		}
		
	}

	
	@Override
	public ExternalResourceLink createExternalResourceLink(String name,
			String description, String mimeType, String resourceId,
			String pluginName) throws InternalErrorException, ItemAlreadyExistException,
			InsufficientPrivilegesException {
		try {
			return workspace.createExternalResourceLink(name, description, mimeType,
					resourceId, pluginName, getId());
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WrongDestinationException e) {
			throw new InternalErrorException(e);
		}
	}

}
