package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;


public class JCRWorkspaceFolder extends JCRAbstractWorkspaceFolder {

		
	public JCRWorkspaceFolder(JCRWorkspace workspace, Node node) throws RepositoryException {
		super(workspace,node);	
	}
	
	public JCRWorkspaceFolder(JCRWorkspace workspace, Node node,
			String name, String description) throws RepositoryException  {		
		super(workspace,node,name,description);
	}

	@Override
	public WorkspaceItemType getType() {
		return WorkspaceItemType.FOLDER;
	}

	@Override	
	public WorkspaceSharedFolder share(List<String> users) throws InsufficientPrivilegesException,
	WrongDestinationException, InternalErrorException {

		try {
			return workspace.shareFolder(users, getId());
		} catch (ItemNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (WorkspaceFolderNotFoundException e) {
			throw new InternalErrorException(e);
		} catch (InternalErrorException e) {
			throw new InternalErrorException(e);
		}

	}

	
}
