package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRWorkflowTemplate extends JCRWorkspaceFolderItem implements
		WorkflowTemplate {
	
	private static String NT_CONTENT = "nthl:workspaceLeafItemContent";
	
	public JCRWorkflowTemplate(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
		super(workspace, node);
	}
	
	public JCRWorkflowTemplate(JCRWorkspace workspace, Node node, String name,
			String description, String workflowId, String workflowStatus,
			String workflowData) throws RepositoryException  {
		super(workspace, node, name, description);
		
		node.addNode(CONTENT, NT_CONTENT);
		node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.WORKFLOW_TEMPLATE.toString());

		node.setProperty(WORKFLOW_DATA, workflowData);
		node.setProperty(WORKFLOW_ID, workflowId);
		node.setProperty(WORKFLOW_STATUS, workflowStatus);
	}

	@Override
	public long getLength() throws InternalErrorException {
		return 0;
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.WORKFLOW_TEMPLATE;
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		
	}

}
